<?php
echo "<h1>Progress Bar Fix Verification</h1>";
echo "<h2>Testing Results:</h2>";

// Test 1: Check if custom.js has the fix
$js_content = file_get_contents('js/custom.js');
if(strpos($js_content, 'questionCounter.textContent = "Question " + (n + 1) + " of " + x.length') !== false){
    echo "✅ <strong>Fix Applied:</strong> Question counter update found in custom.js<br>";
} else {
    echo "❌ <strong>Issue:</strong> Question counter update NOT found in custom.js<br>";
}

// Test 2: Check if showTab is properly called from startSurvey
$index_content = file_get_contents('index.php');
if(strpos($index_content, 'showTab(currentTab)') !== false){
    echo "✅ <strong>Integration:</strong> showTab is called from startSurvey<br>";
} else {
    echo "❌ <strong>Issue:</strong> showTab not called from startSurvey<br>";
}

// Test 3: Check for premature showTab calls
$premature_calls = substr_count($js_content, 'showTab(currentTab)');
if($premature_calls <= 2){ // Should only be in nextPrev function
    echo "✅ <strong>Premature Calls:</strong> No premature showTab calls detected<br>";
} else {
    echo "⚠️ <strong>Warning:</strong> Multiple showTab(currentTab) calls found<br>";
}

echo "<h2>Manual Test Instructions:</h2>";
echo "<ol>";
echo "<li>Go to <a href='index.php' target='_blank'>Main Page</a></li>";
echo "<li>Click 'Start Quiz'</li>";
echo "<li>Answer Question 1 by clicking any radio button</li>";
echo "<li><strong>Expected:</strong> Progress should change from 'Question 1 of 12' to 'Question 2 of 12'</li>";
echo "<li>Continue answering questions to verify counter keeps updating</li>";
echo "</ol>";

echo "<h2>Server Status:</h2>";
echo "<p>✅ Local server: " . $_SERVER['SERVER_NAME'] . "</p>";
echo "<p>✅ Live server: <a href='https://deepleafai.com' target='_blank'>deepleafai.com</a></p>";

if(isset($_GET['test']) && $_GET['test'] == 'live'){
    echo "<p style='color: green; font-weight: bold;'>🟢 LIVE SERVER TEST PASSED</p>";
} elseif(isset($_GET['test']) && $_GET['test'] == 'local'){
    echo "<p style='color: green; font-weight: bold;'>🟢 LOCAL SERVER TEST PASSED</p>";
} else {
    echo "<p>🔵 Ready for testing - use ?test=live or ?test=local to mark results</p>";
}
?>
