<?php
// Quick verification script for deployment success
echo "=== DEPLOYMENT VERIFICATION ===\n\n";

$errors = 0;

try {
    // Test database connection
    $pdo = new PDO(
        "mysql:host=localhost;dbname=loudcannabisnear_survey",
        "root",
        $_ENV["DB_PASS"] ?? "REPLACE_WITH_ACTUAL_PASSWORD",
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "✅ Database connection successful\n";

    // Check if survey progress table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'tbl_survey_progress'");
    if ($stmt->fetch()) {
        echo "✅ tbl_survey_progress table exists\n";

        // Test table functionality
        $stmt = $pdo->prepare("INSERT INTO tbl_survey_progress (session_id, current_tab, survey_answers) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE current_tab = VALUES(current_tab)");
        $stmt->execute(['test_session_' . time(), 1, '{"test": "data"}']);

        echo "✅ Table write test successful\n";

        // Clean up test data
        $stmt = $pdo->prepare("DELETE FROM tbl_survey_progress WHERE session_id LIKE 'test_session_%'");
        $stmt->execute();

        echo "✅ Test data cleanup successful\n";

    } else {
        echo "❌ tbl_survey_progress table MISSING\n";
        $errors++;
    }

} catch (PDOException $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
    $errors++;
}

echo "\n=== VERIFICATION RESULTS ===\n";
if ($errors === 0) {
    echo "🎉 ALL CHECKS PASSED - Deployment successful!\n";
    echo "\n🧪 Ready for live testing at https://deepleafai.com\n";
} else {
    echo "❌ $errors errors found - Deployment may have failed\n";
    echo "\n🔧 Please check the deployment steps and try again\n";
}

echo "\n📋 Next Steps:\n";
echo "1. Run comprehensive tests from LIVE_TESTING_CHECKLIST.md\n";
echo "2. Monitor browser console for any errors\n";
echo "3. Test complete user flow: Survey → AI Chat\n";
echo "4. Verify progress saves work correctly\n";
?>
