<?php
// Test Monetization Flow Script
error_reporting(E_ALL);
ini_set('display_errors', 1);

$api_url = 'http://localhost/leadgen/api/openai_chat.php';

// Helper to make API requests
function call_api($message, $survey_data) {
    global $api_url;
    $payload = json_encode([
        'message' => $message,
        'survey' => $survey_data,
        'history' => [],
        'preferences' => ['topics' => ['cannabis', 'business']]
    ]);

    $ch = curl_init($api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Helper to update session file manually (simulating "Reject" action)
function reject_offer($user_id, $offer_id) {
    $session_file = __DIR__ . '/api/sessions/' . $user_id . '.json';
    if (!file_exists($session_file)) {
        echo "Error: Session file not found for $user_id\n";
        return;
    }

    $session = json_decode(file_get_contents($session_file), true);
    if (!isset($session['rejected_offers'])) {
        $session['rejected_offers'] = [];
    }
    $session['rejected_offers'][] = $offer_id;
    file_put_contents($session_file, json_encode($session, JSON_PRETTY_PRINT));
    echo "-> Offer '$offer_id' rejected in session.\n";
}

// Helper to simulate payment (Insert DB + Update Session)
function simulate_payment($user_id, $offer_id, $amount) {
    // 1. Insert into DB
    $cmd = "mysql -u leadgen -p$_ENV['DB_PASS'] ?? 'REPLACE_WITH_ACTUAL_PASSWORD' loudcannabisnear_survey -e \"INSERT INTO tbl_transactions (user_id, offer_id, amount, status) VALUES ('$user_id', '$offer_id', $amount, 'completed');\"";
    exec($cmd, $output, $return_var);
    if ($return_var !== 0) {
        echo "-> DB Insert Failed!\n";
    } else {
        echo "-> DB Insert Success (tbl_transactions).\n";
    }

    // 2. Update Session
    $session_file = __DIR__ . '/api/sessions/' . $user_id . '.json';
    if (!file_exists($session_file)) {
        echo "-> Error: Session file not found for payment simulation.\n";
        return;
    }

    $session = json_decode(file_get_contents($session_file), true);
    
    if (!isset($session['completed_offers'])) $session['completed_offers'] = [];
    if (!in_array($offer_id, $session['completed_offers'])) {
        $session['completed_offers'][] = $offer_id;
        $session['offers_completed'] = ($session['offers_completed'] ?? 0) + 1;
        // Upgrade tier if 2+ offers
        if ($session['offers_completed'] >= 1) {
             echo "-> User upgraded to ENGAGED/PREMIUM tier.\n";
        }
    }

    // Remove from rejected if it was there (re-engagement)
    if (isset($session['rejected_offers'])) {
        $session['rejected_offers'] = array_diff($session['rejected_offers'], [$offer_id]);
    }

    file_put_contents($session_file, json_encode($session, JSON_PRETTY_PRINT));
    echo "-> Session updated: Offer '$offer_id' marked as completed.\n";
}

// Mock User Data
$survey_data = [
    'name' => 'TestUser_' . time(),
    'email' => 'test' . time() . '@example.com',
    'answers' => [
        '09' => 'money', // Goal: Money (Matches Business Offer)
        '04' => 'debt',  // Financial: Debt (Matches Debt Offer)
        '05' => 'yes invest', // Interest: Investing
        '10' => 'planning to start' // Business: Aspiring
    ]
];

echo "=== Starting Monetization Flow Test ===\n";
echo "User: {$survey_data['name']}\n\n";

// Step 1: Initial Request (Should get Highest Value Offer)
echo "1. Sending initial request...\n";
$response1 = call_api("I want to start a cannabis business but I have debt.", $survey_data);
$offer1 = $response1['suggestions'][0] ?? null;
$user_id = $response1['session_info']['user_id'] ?? null;

if ($offer1) {
    echo "-> Received Offer 1: " . $offer1['title'] . " (ID: " . $offer1['id'] . ", Score: " . $offer1['score'] . ")\n";
} else {
    echo "-> No offer received (Unexpected).\n";
    exit;
}

// Step 2: Simulate PAYING for Offer 1
echo "\n2. Simulating PAYMENT for Offer 1...\n";
simulate_payment($user_id, $offer1['id'], 45.00);

// Step 3: Verify Upgrade & Next Offer
echo "\n3. Sending second request (Should be upgraded & see next offer)...\n";
$response2 = call_api("What about getting funding?", $survey_data);
$offer2 = $response2['suggestions'][0] ?? null;

// Check if response contains "TEASER MODE" warning (Should be GONE now)
if (strpos($response2['response'], 'TEASER MODE') !== false) {
    echo "-> FAIL: Still in TEASER MODE after payment!\n";
} else {
    echo "-> PASS: TEASER MODE disabled (Full Answer Given).\n";
}

if ($offer2) {
    echo "-> Received Offer 2: " . $offer2['title'] . " (ID: " . $offer2['id'] . ", Score: " . $offer2['score'] . ")\n";
    if ($offer2['id'] === $offer1['id']) {
        echo "FAIL: Offer 2 is same as Offer 1 (Already paid for)!\n";
    } else {
        echo "PASS: Offer 2 is different.\n";
    }
} else {
    echo "-> No offer received (Unexpected).\n";
}

// Step 4: Reject Offer 2
echo "\n4. Rejecting Offer 2...\n";
if ($offer2) reject_offer($user_id, $offer2['id']);

// Step 5: Third Request (Should get Next Best Offer)
echo "\n5. Sending third request...\n";
$response3 = call_api("Is there anything else?", $survey_data);
$offer3 = $response3['suggestions'][0] ?? null;

if ($offer3) {
    echo "-> Received Offer 3: " . $offer3['title'] . " (ID: " . $offer3['id'] . ", Score: " . $offer3['score'] . ")\n";
}

// Step 6: Reject Remaining
echo "\n6. Rejecting remaining offers to force Billing Wall...\n";
if ($offer3) reject_offer($user_id, $offer3['id']);
reject_offer($user_id, 'solar_grow_energy'); 
reject_offer($user_id, 'medical_wellness_program');

// Step 7: Final Request (Should Trigger Billing Wall)
echo "\n7. Sending final request (Expect Billing Wall)...\n";
$responseFinal = call_api("I need more help.", $survey_data);
$offerFinal = $responseFinal['suggestions'][0] ?? null;

if (empty($offerFinal)) {
    echo "-> PASS: No offers returned.\n";
    if (strpos($responseFinal['response'], 'https://deepleafai.com/billing') !== false) {
        echo "-> PASS: AI Response contains billing link.\n";
    } else {
        echo "-> WARN: AI Response missing billing link.\n";
    }
} else {
    echo "-> FAIL: Still received offer: " . $offerFinal['title'] . "\n";
}

echo "\n=== Test Complete ===\n";
?>

