<?php
require_once '../src/Services/config_parser.php';
$config = load_config();

echo "Testing socket connection...<br>";

try {
    $pdo = new PDO(
        "mysql:unix_socket=/var/run/mysqld/mysqld.sock;dbname=" . $config['DB_NAME'],
        $config['DB_USER'],
        $config['DB_PASS'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    echo "✅ Socket database connection successful!<br>";
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM affiliates");
    $result = $stmt->fetch();
    echo "Affiliates count: " . $result['count'] . "<br>";
} catch (Exception $e) {
    echo "❌ Socket database connection failed: " . $e->getMessage() . "<br>";
}
?>
