<?php

/**
 * Test Bootstrap
 * Sets up the testing environment
 */

// Define test constants (only if not already defined)
if (!defined('TESTING')) {
    define('TESTING', true);
}
if (!defined('APP_ROOT')) {
    define('APP_ROOT', dirname(__DIR__));
}
if (!defined('APP_ENV')) {
    define('APP_ENV', 'testing');
}
if (!defined('APP_DEBUG')) {
    define('APP_DEBUG', true);
}

// For unit tests, don't load full app config to avoid constant conflicts
// Only load minimal requirements for tests

// Mock database connection for tests
class TestDatabase {
    private static $connection = null;

    public static function getConnection() {
        if (self::$connection === null) {
            try {
                self::$connection = new PDO(
                    'mysql:host=' . (getenv('DB_HOST') ?: 'localhost') . ';dbname=test_db',
                    getenv('DB_USER') ?: 'root',
                    getenv('DB_PASS') ?: '',
                    [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
                );
            } catch (PDOException $e) {
                // For tests that don't need DB, we'll skip
                self::$connection = false;
            }
        }
        return self::$connection;
    }
}

// Include autoloader
require_once APP_ROOT . '/src/bootstrap.php';
