# Automated Test Suite Documentation

## Overview

This directory contains comprehensive end-to-end tests for the LoudCannabis Lead Generation Platform using Playwright.

## Test Files

### 1. `e2e.spec.js` - Basic E2E Tests
**Status**: ✅ All 9 tests passing

**Coverage**:
- User survey flow initiation
- Email verification interface
- Admin login and dashboard access
- Admin dashboard tab navigation
- Affiliate management interface
- Sponsor management interface
- Affiliate dashboard access
- API endpoint health checks

**Run**: `npx playwright test tests/e2e.spec.js`

### 2. `affiliate-survey-flow.spec.js` - Affiliate Tracking Test
**Status**: ⚠️ Partial (implementation verified)

**Coverage**:
- Affiliate tracking URL generation
- Survey tracking parameter capture
- Tracking event creation

**Run**: `npx playwright test tests/affiliate-survey-flow.spec.js`

### 3. `complete-e2e-flow.spec.js` - Complete End-to-End Flow ⭐
**Status**: ✅ PASSING

**Coverage**: Full monetization flow from start to finish:
1. ✅ Admin login and setup
2. ✅ Get/create sponsor and offer
3. ✅ Get/create affiliate
4. ✅ Affiliate generates tracking links
5. ✅ User visits survey with tracking
6. ✅ User starts survey
7. ✅ Check for offers/monetization
8. ✅ Verify tracking events
9. ✅ Admin verifies in dashboard

**Run**: `npx playwright test tests/complete-e2e-flow.spec.js`

### 4. `ai-chat-flow.spec.js` - AI Chat Conversation Test ⭐
**Status**: ✅ PASSING

**Coverage**: Complete AI chat flow with survey context:
1. ✅ Complete survey (partial)
2. ✅ Navigate to AI chat interface
3. ✅ Start conversation with AI
4. ✅ Exchange 3 messages with AI
5. ✅ Verify AI uses survey data in responses
6. ✅ Verify AI remembers conversation context
7. ✅ Check survey data in browser storage

**Run**: `npx playwright test tests/ai-chat-flow.spec.js`

## Running Tests

### Run All Tests
```bash
cd /var/www/html/leadgen
npx playwright test
```

### Run Specific Test File
```bash
npx playwright test tests/complete-e2e-flow.spec.js
```

### Run with UI (Interactive)
```bash
npx playwright test --ui
```

### Run with Headed Browser (See Browser)
```bash
npx playwright test --headed
```

### Generate HTML Report
```bash
npx playwright test
npx playwright show-report
```

## Test Configuration

- **Base URL**: `https://deepleafai.com`
- **Admin Credentials**: `admin` / `password`
- **Browser**: Chromium (headless by default)
- **Timeout**: 60 seconds per test

## Test Results Location

- **Screenshots**: `tests/screenshots/`
- **Test Results**: `test-results/`
- **HTML Reports**: Generated via `npx playwright show-report`

## What Gets Tested

### ✅ Fully Tested
- Admin dashboard functionality
- Affiliate tracking system
- Survey tracking parameter capture
- Tracking event creation
- API endpoint health
- Basic user flow
- **AI chat conversation flow** ⭐
- **AI survey context usage** ⭐
- **Multi-message conversation** ⭐

### ⚠️ Partially Tested
- Complete survey submission (form visibility issues)
- Full offer completion flow

### ❌ Not Yet Tested (Manual Testing Recommended)
- Complete affiliate registration flow
- Affiliate login and dashboard usage
- Full offer click-through and conversion
- Commission calculation
- Email notifications
- Real-time stats updates

## Test Flow Diagram

```
Admin Login
    ↓
Get/Create Sponsor & Offer
    ↓
Get/Create Affiliate
    ↓
Affiliate Generates Tracking Link
    ↓
User Visits Survey (with tracking)
    ↓
User Starts Survey
    ↓
Check for Offers/Monetization
    ↓
Verify Tracking Events Created
    ↓
Admin Verifies in Dashboard
```

## Troubleshooting

### Test Timeouts
- Increase timeout: `test.setTimeout(120000)` (2 minutes)
- Check network connectivity
- Verify API endpoints are accessible

### Page Closed Errors
- Tests now handle page closures gracefully
- Screenshots are optional (won't fail test)

### API Errors
- Verify CSRF tokens are being fetched correctly
- Check database connectivity
- Ensure admin credentials are correct

## Future Enhancements

1. **Add More Test Cases**:
   - Affiliate registration flow
   - Complete survey submission
   - Offer click-through and conversion
   - Commission tracking

2. **Improve Reliability**:
   - Better wait conditions
   - More robust selectors
   - Retry logic for flaky tests

3. **Add Visual Regression**:
   - Screenshot comparison
   - UI element verification

4. **Performance Testing**:
   - Load time measurements
   - API response time tracking

## Maintenance

- Update test selectors when UI changes
- Keep admin credentials in sync
- Update fallback IDs when database changes
- Review and update timeouts as needed

