<?php

/**
 * Application Bootstrap
 * Initializes core services and sets up the application
 */

// Include core configuration FIRST
require_once APP_ROOT . '/config/app.php';

// Include security headers
require_once APP_ROOT . '/api/security_headers.php';

// Start secure session
require_once APP_ROOT . '/api/function.php';
secure_session_start();

// Autoload classes (basic implementation - upgrade to Composer later)
spl_autoload_register(function ($className) {
    $baseDir = APP_ROOT . '/src/';

    // Convert namespace to file path
    $fileName = str_replace('\\', '/', $className) . '.php';

    // Try different locations
    $paths = [
        $baseDir . $fileName,
        $baseDir . 'Controllers/' . basename($fileName),
        $baseDir . 'Services/' . basename($fileName),
        $baseDir . 'Models/' . basename($fileName),
        $baseDir . 'Repositories/' . basename($fileName),
    ];

    foreach ($paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            return;
        }
    }
});

/**
 * Basic Application Class
 * TODO: Replace with proper framework (Laravel/Symfony)
 */
class Application {

    private $router;

    public function __construct() {
        $this->router = new Router();
    }

    public function run() {
        try {
            $this->router->dispatch();
        } catch (Exception $e) {
            $this->handleError($e);
        }
    }

    private function handleError(Exception $e) {
        error_log("Application Error: " . $e->getMessage());

        if (APP_DEBUG) {
            echo "<h1>Application Error</h1>";
            echo "<pre>" . $e->getMessage() . "\n" . $e->getTraceAsString() . "</pre>";
        } else {
            echo "An error occurred. Please try again later.";
        }
    }
}

/**
 * Basic Router Class
 * TODO: Replace with proper routing system
 */
class Router {

    public function dispatch() {
        $uri = $_SERVER['REQUEST_URI'];
        $method = $_SERVER['REQUEST_METHOD'];

        // Remove query string
        $uri = parse_url($uri, PHP_URL_PATH);

        // Basic routing for now
        if ($uri === '/' || $uri === '/index.php') {
            $controller = new SurveyController();
            $controller->index();
        } else {
            // For now, serve existing API endpoints
            $this->handleLegacyApi($uri);
        }
    }

    private function handleLegacyApi($uri) {
        // Map legacy API calls
        if (strpos($uri, '/api/') === 0) {
            $apiPath = APP_ROOT . $uri;
            if (file_exists($apiPath)) {
                require_once $apiPath;
                return;
            }
        }

        // Default 404
        header("HTTP/1.0 404 Not Found");
        echo "Page not found";
    }
}
