<?php
    // Start session for rate limiting
    session_start();

    // Rate limiting for SMS
    $sms_rate_limit_key = 'sms_rate_limit_' . $_SERVER['REMOTE_ADDR'];
    if(isset($_SESSION[$sms_rate_limit_key]) && (time() - $_SESSION[$sms_rate_limit_key]) < 60){
        echo json_encode(['error' => 'SMS rate limit exceeded. Please wait before requesting another code.']);
        exit;
    }
    $_SESSION[$sms_rate_limit_key] = time();

    // Load environment variables
    $envFile = __DIR__ . '/config.env';
    if (file_exists($envFile)) {
        $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            if (strpos($line, '#') === 0 || strpos($line, '=') === false) continue;
            list($key, $value) = explode('=', $line, 2);
            $key = trim($key);
            $value = trim($value);
            if (!getenv($key)) {
                putenv("$key=$value");
            }
        }
    }

    // Include phone validation function
    require_once 'api/function.php';
    $dbo = new DBO();

    // Input validation with improved phone validation
    $phone = trim($_POST["phone"] ?? '');
    $phoneValidation = $dbo->validate_and_normalize_phone($phone);
    
    if(!$phoneValidation['valid']){
        echo json_encode(['error' => $phoneValidation['error']]);
        exit;
    }
    
    $normalizedPhone = $phoneValidation['normalized'];

    require 'vendor/autoload.php';
    use Twilio\Rest\Client;

    // Get credentials from environment variables
    $account_sid = getenv('TWILIO_ACCOUNT_SID');
    $auth_token = getenv('TWILIO_AUTH_TOKEN');
    $twilio_number = getenv('TWILIO_PHONE_NUMBER');

    // Check if credentials are set
    if(!$account_sid || !$auth_token || !$twilio_number){
        error_log("Twilio credentials not configured");
        echo json_encode(['error' => 'SMS service temporarily unavailable']);
        exit;
    }

    try {
        $client = new Client($account_sid, $auth_token);

        // Generate secure random code
        $randomNumber = random_int(100000, 999999);
        $phoneNumber = $normalizedPhone;

        // Send SMS
        $client->messages->create(
            $phoneNumber,
            array(
                'from' => $twilio_number,
                'body' => "Your verification code is: " . $randomNumber
            )
        );

        // Store verification data securely
        $verification_token = bin2hex(random_bytes(32));
        $verification_data = [
            'code' => password_hash((string)$randomNumber, PASSWORD_DEFAULT),
            'phone' => $phoneNumber,
            'timestamp' => time(),
            'attempts' => 0
        ];

        $_SESSION['sms_verification_' . $verification_token] = $verification_data;

        echo json_encode(['token' => $verification_token]);

    } catch (Exception $e) {
        error_log("SMS sending error: " . $e->getMessage());
        echo json_encode(['error' => 'Failed to send SMS. Please try again.']);
    }

    exit;
?>