<?php
// Standalone email verification endpoint - no database dependencies
ob_start();
header('Content-Type: application/json; charset=UTF-8');
session_start();

// Load environment variables
$envFiles = ['/var/www/html/leadgen/config.env', '/var/www/html/config.env'];
foreach ($envFiles as $envFile) {
    if (file_exists($envFile)) {
        $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            if (strpos($line, '#') === 0 || strpos($line, '=') === false) continue;
            list($key, $value) = explode('=', $line, 2);
            $key = trim($key);
            $value = trim($value);
            if (!getenv($key)) {
                putenv("$key=$value");
            }
        }
        break;
    }
}

// Input validation
$email = trim($_POST["email"] ?? '');
if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    ob_clean();
    echo json_encode(['error' => 'Please enter a valid email address']);
    exit;
}
$normalizedEmail = strtolower($email);

// Rate limiting per email and IP
$email_rate_key = 'email_rate_limit_' . md5($normalizedEmail);
$ip_rate_key = 'email_rate_limit_' . ($_SERVER['REMOTE_ADDR'] ?? 'unknown');
if ((isset($_SESSION[$email_rate_key]) && (time() - $_SESSION[$email_rate_key]) < 60) ||
    (isset($_SESSION[$ip_rate_key]) && (time() - $_SESSION[$ip_rate_key]) < 30)) {
    ob_clean();
    echo json_encode(['error' => 'Please wait before requesting another verification code.']);
    exit;
}
$_SESSION[$email_rate_key] = time();
$_SESSION[$ip_rate_key] = time();

// Feature flag
$email_enabled = getenv('EMAIL_VERIFICATION_ENABLED') ?: 'true';
if ($email_enabled !== 'true') {
    ob_clean();
    echo json_encode(['error' => 'Email verification temporarily unavailable']);
    exit;
}

try {
    $randomNumber = random_int(100000, 999999);

    $subject = "DeepLeaf AI - Email Verification Code";
    $message = "<html><body>";
    $message .= "<div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;'>";
    $message .= "<h2 style='color: #2d3748; text-align: center; margin-bottom: 10px;'>🌱 Hello!</h2>";
    $message .= "<p style='font-size: 16px; color: #4a5568; text-align: center;'>Welcome to DeepLeaf AI</p>";
    $message .= "<br>";
    $message .= "<p style='font-size: 16px; color: #4a5568; text-align: center;'>🔐 Your verification code is:</p>";
    $message .= "<div style='background: linear-gradient(135deg, #f7fafc 0%, #e2e8f0 100%); border: 2px solid #2b6cb0; border-radius: 12px; padding: 30px; text-align: center; margin: 25px 0;'>";
    $message .= "<span style='font-size: 36px; font-weight: bold; color: #2b6cb0; letter-spacing: 6px; font-family: \"Courier New\", monospace;'>" . $randomNumber . "</span>";
    $message .= "</div>";
    $message .= "<p style='font-size: 14px; color: #718096; text-align: center;'>⏰ This code will expire in <strong>10 minutes</strong></p>";
    $message .= "<br>";
    $message .= "<p style='font-size: 14px; color: #718096; text-align: center; font-style: italic;'>If you didn't request this code, please ignore this email.</p>";
    $message .= "<hr style='border: none; border-top: 2px solid #e2e8f0; margin: 40px 0;'>";
    $message .= "<div style='text-align: center;'>";
    $message .= "<p style='font-size: 14px; color: #4a5568; margin-bottom: 5px;'>📧 Best regards,</p>";
    $message .= "<p style='font-size: 16px; color: #2d3748; margin-bottom: 5px;'><strong>DeepLeaf AI Team</strong></p>";
    $message .= "<p style='font-size: 14px; color: #4a5568;'><a href='https://www.deepleafai.com' style='color: #3182ce; text-decoration: none;'>🌐 www.deepleafai.com</a></p>";
    $message .= "</div>";
    $message .= "</div></body></html>";

    $from = 'noreply@deepleafai.com';
    $headers = "From: DeepLeaf AI <{$from}>\r\n";
    $headers .= "Reply-To: support@deepleafai.com\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();

    // Align envelope sender with From for SPF/DMARC alignment
    $additional_params = '-f ' . escapeshellarg($from);
    $mail_sent = mail($normalizedEmail, $subject, $message, $headers, $additional_params);
    if (!$mail_sent) {
        throw new Exception('Failed to send email');
    }

    // Reset any prior tokens for this email
    foreach ($_SESSION as $key => $value) {
        if (strpos($key, 'email_verification_') === 0) {
            if (is_array($value) && ($value['email'] ?? '') === $normalizedEmail) {
                unset($_SESSION[$key]);
            }
        }
    }

    $verification_token = bin2hex(random_bytes(32));
    $_SESSION['email_verification_' . $verification_token] = [
        'code' => password_hash((string)$randomNumber, PASSWORD_DEFAULT),
        'email' => $normalizedEmail,
        'timestamp' => time(),
        'attempts' => 0,
        'survey_token' => $_POST['survey_token'] ?? null
    ];

    ob_clean();
    echo json_encode(['success' => true, 'token' => $verification_token]);
} catch (Exception $e) {
    error_log('Email sending error: ' . $e->getMessage());
    ob_clean();
    echo json_encode(['error' => 'Failed to send email. Please try again.']);
}
exit;
