<?php
/**
 * RAG Bridge - Connects PHP API to Python RAG System
 */

// Function to retrieve RAG context for a user message
function retrieveRAGContext($message, $survey_insights) {
    // Check if Flask RAG service is running
    $flask_url = 'http://localhost:5000/ask';

    // Prepare the request data
    $rag_data = [
        'question' => $message,
        'k' => 5, // Number of chunks to retrieve
        'context' => $survey_insights // Pass survey insights for better context
    ];

    try {
        // Initialize cURL
        $ch = curl_init($flask_url);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($rag_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15); // 15 second timeout
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);

        curl_close($ch);

        if ($http_code === 200 && !$error) {
            $rag_result = json_decode($response, true);

            if ($rag_result && isset($rag_result['answer'])) {
                // Return the enriched answer and sources for integration
                return [
                    'context' => $rag_result['answer'],
                    'sources' => $rag_result['sources'] ?? []
                ];
            }
        }

        // Log RAG failures but don't break the system
        error_log("RAG Bridge Error: HTTP $http_code, Error: $error");

    } catch (Exception $e) {
        error_log("RAG Bridge Exception: " . $e->getMessage());
    }

    // Return null if RAG fails - the system will continue without RAG
    return null;
}
?>

