<?php
    session_start();

    // Input validation
    $token = trim($_POST["token"] ?? '');
    $user_code = trim($_POST["sms"] ?? '');

    if(empty($token) || empty($user_code) || !preg_match('/^\d{6}$/', $user_code)){
        echo json_encode(['error' => 'Invalid verification code']);
        exit;
    }

    // Check if verification token exists
    $verification_key = 'sms_verification_' . $token;
    if(!isset($_SESSION[$verification_key])){
        echo json_encode(['error' => 'Verification session expired']);
        exit;
    }

    $verification_data = $_SESSION[$verification_key];

    // Check if verification has expired (5 minutes)
    if(time() - $verification_data['timestamp'] > 300){
        unset($_SESSION[$verification_key]);
        echo json_encode(['error' => 'Verification code has expired']);
        exit;
    }

    // Check attempt limit (max 3 attempts)
    if($verification_data['attempts'] >= 3){
        unset($_SESSION[$verification_key]);
        echo json_encode(['error' => 'Too many failed attempts']);
        exit;
    }

    // Verify the code
    if(password_verify($user_code, $verification_data['code'])){
        // Success - clean up session
        unset($_SESSION[$verification_key]);
        echo json_encode(['success' => true]);
    } else {
        // Failed attempt - increment counter
        $verification_data['attempts']++;
        $_SESSION[$verification_key] = $verification_data;
        echo json_encode(['error' => 'Invalid verification code']);
    }

    exit;
