<?php
// Simple email verification endpoint
ob_start();
header('Content-Type: application/json; charset=UTF-8');

// Direct database connection for email verification
$host = 'localhost';
$user = 'leadgen';
$pass = $_ENV['DB_PASS'] ?? 'REPLACE_WITH_ACTUAL_PASSWORD';
$dbname = 'loudcannabisnear_survey';

try {
    $pdo = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $user,
        $pass,
        array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        )
    );
} catch(PDOException $e) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

// Start session manually
session_start();

// Add debug logging
error_log("=== EMAIL VERIFICATION DEBUG ===");
error_log("Session ID: " . session_id());
error_log("POST data: " . json_encode($_POST));
error_log("Session before verification: " . json_encode([
    'email_verified' => $_SESSION['email_verified'] ?? 'not set',
    'verified_email' => $_SESSION['verified_email'] ?? 'not set',
    'survey_token' => $_SESSION['survey_token'] ?? 'not set'
]));

$code = trim($_POST['email_code'] ?? '');
$token = trim($_POST['token'] ?? '');

if ($code === '' || $token === '') {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Missing code or token']);
    exit;
}

$key = 'email_verification_' . $token;
if (!isset($_SESSION[$key])) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Invalid or expired token']);
    exit;
}

$data = $_SESSION[$key] ?? null;

if (!$data) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Invalid session data', 'debug' => ['session_key' => $key, 'session_exists' => isset($_SESSION[$key])]]);
    exit;
}

// Expire after 10 minutes
if (time() - ($data['timestamp'] ?? 0) > 600) {
    unset($_SESSION[$key]);
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Verification code expired']);
    exit;
}

// Track attempts, limit to 5
$data['attempts'] = ($data['attempts'] ?? 0) + 1;
$_SESSION[$key] = $data;
if ($data['attempts'] > 5) {
    unset($_SESSION[$key]);
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Too many attempts']);
    exit;
}

$provided = (string)$code;

// For now, we'll do a simple string comparison since we're dealing with the raw code
// In production, this should use proper password hashing
$stored_code = $data['code'] ?? '';

if (empty($stored_code)) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'No verification code in session']);
    exit;
}

// Check if the provided code matches (either hashed or plain)
$code_matches = false;
if (password_verify($provided, $stored_code)) {
    $code_matches = true;
} elseif ($provided === $stored_code) {
    $code_matches = true;
}

if (!$code_matches) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Incorrect verification code']);
    exit;
}

// Verification successful - mark email as verified for subsequent survey submission
$_SESSION['email_verified'] = true;
if (!empty($data['email'])) {
    $_SESSION['verified_email'] = $data['email'];

    // Update database to mark email as verified
    try {
        $stmt = $pdo->prepare("UPDATE tbl_survey SET email_verified = 1, email_verified_at = NOW() WHERE email = ? ORDER BY created DESC LIMIT 1");
        $stmt->execute([$data['email']]);
    } catch(PDOException $e) {
        error_log("Failed to update email verification status: " . $e->getMessage());
    }
}
if (!empty($data['survey_token'])) {
    $_SESSION['survey_token'] = $data['survey_token'];
}

// Add debug logging after setting session variables
error_log("Session after verification: " . json_encode([
    'email_verified' => $_SESSION['email_verified'] ?? 'not set',
    'verified_email' => $_SESSION['verified_email'] ?? 'not set',
    'survey_token' => $_SESSION['survey_token'] ?? 'not set'
]));

// Invalidate this verification token after success
unset($_SESSION[$key]);

error_log("Email verification successful for: " . $data['email']);

ob_clean();
echo json_encode(['success' => true, 'email' => $data['email'], 'survey_token' => $data['survey_token']]);
exit;

ob_clean();
echo json_encode(['success' => false, 'error' => 'Incorrect code']);
exit;
