<?php

class AuthMiddleware {
    private $db;
    
    public function __construct($db) {
        $this->db = $db;
    }
    
    public function authenticateAffiliate() {
        // Check for Authorization header
        $headers = getallheaders();
        $auth_header = $headers['Authorization'] ?? '';
        
        if (empty($auth_header)) {
            // Check for token in GET/POST
            $token = $_GET['token'] ?? $_POST['token'] ?? '';
        } else {
            // Extract token from Bearer header
            if (preg_match('/Bearer\s+(.*)$/i', $auth_header, $matches)) {
                $token = $matches[1];
            } else {
                $token = $auth_header;
            }
        }
        
        if (empty($token)) {
            http_response_code(401);
            echo json_encode(['error' => 'Authentication required']);
            exit;
        }
        
        // For now, we'll use a simple token validation
        // In production, you'd want proper JWT or session tokens
        $stmt = $this->db->prepare("SELECT id, email, company_name, status FROM affiliates WHERE unique_id = ? AND status = 'active'");
        $stmt->execute([$token]);
        $affiliate = $stmt->fetch();
        
        if (!$affiliate) {
            http_response_code(401);
            echo json_encode(['error' => 'Invalid or expired token']);
            exit;
        }
        
        return $affiliate;
    }
    
    public function getAffiliateFromToken($token) {
        $stmt = $this->db->prepare("SELECT id, email, company_name, status FROM affiliates WHERE unique_id = ? AND status = 'active'");
        $stmt->execute([$token]);
        return $stmt->fetch();
    }
}
?>
