<?php

/**
 * Survey Controller
 * Handles survey display and processing
 * Refactored from the original 1,492-line index.php monster file
 */

class SurveyController {

    public function index() {
        // Load questions
        $questions = $this->loadQuestions();

        // Get any existing survey data from session/token
        $existingData = $this->getExistingSurveyData();

        // Render the survey view
        $this->renderSurvey($questions, $existingData);
    }

    private function loadQuestions() {
        $questionsFile = APP_ROOT . '/api/questions.json';

        if (!file_exists($questionsFile)) {
            throw new Exception("Questions file not found");
        }

        $content = file_get_contents($questionsFile);
        $questions = json_decode($content, true);

        if (!$questions) {
            throw new Exception("Invalid questions JSON");
        }

        return $questions;
    }

    private function getExistingSurveyData() {
        // Check for token in URL or session
        $token = $_GET['token'] ?? $_SESSION['survey_token'] ?? null;

        if ($token) {
            // Load from database if available
            // For now, return empty array
            return [];
        }

        return [];
    }

    private function renderSurvey($questions, $existingData) {
        // Include security headers
        require_once APP_ROOT . '/api/security_headers.php';

        // Start output buffering for the view
        ob_start();
        ?>

        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="p:domain_verify" content="25fda4a81633b66f76c6cba35522d8c7"/>
            <meta name="viewport" content="width=device-width, initial-scale=1">

            <!-- Global site tag (gtag.js) - Google Analytics -->
            <script async src="https://www.googletagmanager.com/gtag/js?id=UA-153724287-1"></script>
            <script>
              window.dataLayer = window.dataLayer || [];
              function gtag(){dataLayer.push(arguments);}
              gtag('js', new Date());
              gtag('config', 'UA-153724287-1');
            </script>

           <title> LoudCannabis | Find Loudest for the best Price!</title>
           <meta name="description" content="Looking for the best cannabis deals and events in your area? Expect free cannabis, raffles and prizes on a weekly basis!" />

           <link rel="stylesheet" href="../css/bootstrap.min.css">

            <!-- jQuery with CDN fallback -->
            <script>
            if (typeof jQuery == 'undefined') {
                document.write('<script src="js/jquery-3.6.0.min.js"><\/script>');
            }
            </script>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

            <style>
                /* Critical styles - move to separate CSS file later */
                body { font-family: Arial, sans-serif; background: #f8f9fa; }
                .survey-container { max-width: 800px; margin: 0 auto; padding: 20px; }
                .question-card { margin-bottom: 20px; padding: 20px; border: 1px solid #ddd; border-radius: 8px; }
                .btn-primary { background-color: #007bff; border-color: #007bff; }
                .btn-primary:hover { background-color: #0056b3; }
            </style>
        </head>

        <body>
            <div class="survey-container">
                <h1 class="text-center mb-4">Find Your Perfect Cannabis Match</h1>
                <p class="text-center mb-4">Answer a few questions and get personalized recommendations from our AI system.</p>

                <form id="surveyForm" method="post" action="submit.php">
                    <?php foreach ($questions as $index => $question): ?>
                        <div class="question-card">
                            <h4 class="mb-3">Question <?php echo $index + 1; ?></h4>
                            <p class="mb-3"><?php echo htmlspecialchars($question['question']); ?></p>

                            <?php if (isset($question['options'])): ?>
                                <?php foreach ($question['options'] as $option): ?>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="radio"
                                               name="answers[<?php echo $question['id']; ?>]"
                                               value="<?php echo htmlspecialchars($option); ?>"
                                               id="q<?php echo $question['id']; ?>_<?php echo md5($option); ?>">
                                        <label class="form-check-label" for="q<?php echo $question['id']; ?>_<?php echo md5($option); ?>">
                                            <?php echo htmlspecialchars($option); ?>
                                        </label>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <textarea class="form-control"
                                          name="answers[<?php echo $question['id']; ?>]"
                                          rows="3"
                                          placeholder="Your answer here..."></textarea>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>

                    <div class="text-center">
                        <button type="submit" class="btn btn-primary btn-lg px-5">Get My Recommendations</button>
                    </div>
                </form>
            </div>

            <!-- Load existing JavaScript - TODO: Extract to separate file -->
            <script src="../js/bootstrap.min.js"></script>
            <script>
                // Basic form validation - TODO: Move to separate JS file
                document.getElementById('surveyForm').addEventListener('submit', function(e) {
                    const questions = document.querySelectorAll('.question-card');
                    let isValid = true;

                    questions.forEach(function(question, index) {
                        const inputs = question.querySelectorAll('input[type="radio"]:checked, textarea');
                        if (inputs.length === 0 || (inputs[0].tagName === 'TEXTAREA' && !inputs[0].value.trim())) {
                            isValid = false;
                            question.style.borderColor = 'red';
                        } else {
                            question.style.borderColor = '#ddd';
                        }
                    });

                    if (!isValid) {
                        e.preventDefault();
                        alert('Please answer all questions before submitting.');
                    }
                });
            </script>
        </body>
        </html>

        <?php

        $content = ob_get_clean();
        echo $content;
    }
}
