# Manager's Guide - LeadGen AI Chat System

## 🎯 Quick Start for Managers

### Starting the System

1. **Start RAG Flask Server** (Required for admin custom knowledge)
   ```bash
   cd /var/www/html/leadgen/airagagent
   python3 app.py
   ```
   
   Or run in background:
   ```bash
   nohup python3 app.py > /tmp/rag_app.log 2>&1 &
   ```

2. **Verify System Status**
   ```bash
   # Check RAG system
   curl http://localhost:5000/status
   
   # Should show: "total_documents" > 0
   ```

3. **System is Ready!**
   - Chat API: `https://yourdomain.com/api/openai_chat.php`
   - RAG System: `http://localhost:5000`

## 📚 Adding Knowledge to the Chat System

### Step 1: Upload PDF Documents

```bash
# Copy your PDF files to the pdf_directory
cp /path/to/your/book.pdf /var/www/html/leadgen/airagagent/pdf_directory/
```

**Supported formats:**
- PDF files (.pdf)
- Text files (.txt)

### Step 2: Process Documents

The system automatically processes new documents when:
- A user asks a question (triggers processing)
- You call the status endpoint: `curl http://localhost:5000/status`

**Manual processing:**
```bash
# Upload via API (if web interface available)
curl -X POST http://localhost:5000/upload \
  -F "file=@/path/to/book.pdf"
```

### Step 3: Verify Documents Added

```bash
curl http://localhost:5000/status | python3 -m json.tool
```

Look for:
- `"total_documents"` - Should increase after adding books
- `"file_list"` - Lists all processed files

## 🔍 Checking System Health

### Daily Checks

1. **Is RAG Flask running?**
   ```bash
   ps aux | grep "python3 app.py" | grep -v grep
   ```
   If nothing shows, restart it (see below)

2. **How many documents are loaded?**
   ```bash
   curl http://localhost:5000/status | python3 -m json.tool | grep total_documents
   ```

3. **Test chat is working**
   ```bash
   curl -X POST https://yourdomain.com/api/openai_chat.php \
     -H "Content-Type: application/json" \
     -d '{"message":"Test","survey":{"name":"Test","answers":{}}}'
   ```

## 🔄 Common Tasks

### Restart RAG Flask Server

```bash
# Stop existing process
pkill -f "python3 app.py"

# Start fresh
cd /var/www/html/leadgen/airagagent
nohup python3 app.py > /tmp/rag_app.log 2>&1 &

# Verify it started
sleep 3
curl http://localhost:5000/status
```

### View System Logs

```bash
# RAG Flask logs
tail -50 /tmp/rag_app.log

# Follow logs in real-time
tail -f /tmp/rag_app.log
```

### Check What Documents Are in System

```bash
# List processed documents
ls -lh /var/www/html/leadgen/airagagent/processed/documents/

# Get status with file list
curl http://localhost:5000/status | python3 -m json.tool
```

## 📊 Understanding the System

### How It Works

1. **User completes survey** → Data stored in database
2. **User asks question** → Chat API receives question
3. **RAG system searches** → Finds relevant content from your books
4. **AI generates response** → Combines:
   - User's survey data (name, interests, goals)
   - Relevant book content from RAG
   - The question itself

### What Makes Responses Smart

- **More books = Smarter responses**
  - Each book adds knowledge to the system
  - System searches ALL books for relevant content
  - More books = more accurate, detailed answers

- **Current knowledge base:**
  - The Secret Doctrine (H.P. Blavatsky)
  - America B.C. (Barry Fell)
  - The Secret Destiny of America (Manly P. Hall)
  - And more...

## 🛠️ Troubleshooting

### Problem: Chat not using book knowledge

**Check:**
1. Is RAG Flask running? `ps aux | grep "python3 app.py"`
2. Are documents processed? `curl http://localhost:5000/status`
3. Check logs: `tail -50 /tmp/rag_app.log`

**Solution:**
- Restart RAG Flask server
- Verify documents are in `pdf_directory/`
- Check document processing completed

### Problem: RAG Flask won't start

**Check:**
1. Python dependencies installed?
   ```bash
   python3 -c "import flask, sentence_transformers, faiss"
   ```

2. Port 5000 available?
   ```bash
   netstat -tuln | grep 5000
   ```

**Solution:**
- Install missing dependencies
- Kill process using port 5000: `lsof -ti:5000 | xargs kill`

### Problem: Documents not processing

**Check:**
1. File permissions: `ls -la airagagent/pdf_directory/`
2. File format: Must be PDF or TXT
3. RAG Flask logs: `tail -50 /tmp/rag_app.log`

**Solution:**
- Ensure files are readable
- Check file format is supported
- Review logs for specific errors

## 📈 Monitoring

### Key Metrics to Watch

1. **Document Count**
   ```bash
   curl http://localhost:5000/status | grep total_documents
   ```
   Should increase as you add books

2. **RAG Flask Status**
   ```bash
   ps aux | grep "python3 app.py" | wc -l
   ```
   Should be 1 (one process running)

3. **Chat API Response Time**
   - Monitor via web server logs
   - Should be < 5 seconds typically

## 🔐 Security Notes

- RAG Flask runs on `localhost:5000` (not exposed publicly)
- Only PHP chat API is public-facing
- Keep API keys secure in code files
- Regular backups recommended (see backup section)

## 📦 Backup & Restore

### Create Backup

See backup script in main directory or run:
```bash
cd /var/www/html/leadgen
tar -czf backup_$(date +%Y%m%d).tar.gz \
  airagagent/processed/ \
  api/ \
  config/
```

### Restore from Backup

```bash
tar -xzf backup_YYYYMMDD.tar.gz
# Restart RAG Flask server
```

## ✅ Quick Reference

| Task | Command |
|------|---------|
| Start RAG Flask | `cd airagagent && python3 app.py &` |
| Check Status | `curl http://localhost:5000/status` |
| View Logs | `tail -f /tmp/rag_app.log` |
| Add Book | `cp book.pdf airagagent/pdf_directory/` |
| Restart RAG | `pkill -f "python3 app.py" && cd airagagent && python3 app.py &` |
| Test Chat | `curl -X POST https://yourdomain.com/api/openai_chat.php -H "Content-Type: application/json" -d '{"message":"Test","survey":{"name":"Test","answers":{}}}'` |

## 📞 Need Help?

- Check logs first: `/tmp/rag_app.log`
- Verify RAG Flask is running
- Check document count in status endpoint
- Review this guide's troubleshooting section

