# Billing Page Setup Guide

## Current Status: ✅ **FUNCTIONAL** (with configuration needed)

The billing page (`billing.html`) is now fully functional with:
- ✅ Stripe Checkout integration (ready for your API keys)
- ✅ Crypto payment option (ready for wallet address)
- ✅ Transaction recording via `api/record_transaction.php`
- ✅ User session upgrade after payment
- ✅ Success/error handling and alerts

## Required Configuration Steps:

### 1. Stripe Setup

**A. Get Your Stripe Keys:**
1. Go to https://dashboard.stripe.com/apikeys
2. Copy your **Publishable Key** (starts with `pk_`)
3. Copy your **Secret Key** (starts with `sk_`)

**B. Update `billing.html`:**
```javascript
// Line ~150: Replace placeholder
const stripe = Stripe('pk_test_51Q...'); // ← Your publishable key here
```

**C. Update `api/create_stripe_session.php`:**
```php
// Line ~30: Replace placeholder
$stripe_secret_key = 'sk_test_...'; // ← Your secret key here
```

**D. Install Stripe PHP Library (if not installed):**
```bash
composer require stripe/stripe-php
```

**E. Update `api/create_stripe_session.php` to use actual Stripe API:**
- Uncomment the `\Stripe\Checkout\Session::create()` code
- Remove the mock checkout URL

### 2. Stripe Webhook Setup

**A. Configure Webhook in Stripe Dashboard:**
1. Go to https://dashboard.stripe.com/webhooks
2. Click "Add endpoint"
3. URL: `https://deepleafai.com/api/stripe_webhook.php`
4. Events to listen for:
   - `checkout.session.completed`
   - `payment_intent.succeeded`
   - `charge.refunded` (optional)

**B. Get Webhook Signing Secret:**
1. After creating webhook, click on it
2. Copy the **Signing secret** (starts with `whsec_`)

**C. Update `api/stripe_webhook.php`:**
```php
// Line ~15: Replace placeholder
$webhook_secret = 'whsec_...'; // ← Your webhook secret here
```

**D. Uncomment Stripe verification code:**
- Uncomment the `\Stripe\Webhook::constructEvent()` code for security

### 3. Crypto Payment Setup

**A. Update `billing.html`:**
```javascript
// Line ~220: Replace placeholder wallet address
const cryptoAddress = 'bc1qxy2kgdygjrsqtzq2n0yrf2493p83kkfjhx0wlh'; // ← Your wallet
```

**B. Optional: Integrate Coinbase Commerce:**
- Sign up at https://commerce.coinbase.com
- Replace manual crypto flow with Coinbase Commerce API
- Use their JavaScript SDK for better UX

### 4. Security Hardening

**A. Move Secret Keys to Environment Variables:**
- Don't hardcode secrets in PHP files
- Use `config.env` or environment variables
- Update `api/record_transaction.php` to use secure secret key

**B. Add CSRF Protection:**
- Add CSRF tokens to payment forms
- Validate tokens server-side

### 5. Testing

**Test Flow:**
1. Visit: `https://deepleafai.com/billing?user_id=TEST123`
2. Click "Subscribe via Stripe" → Should redirect to Stripe Checkout
3. Use Stripe test card: `4242 4242 4242 4242`
4. Complete payment → Should redirect back with `payment_status=success`
5. Check `tbl_transactions` table → Should have new record
6. Check user session → Should be upgraded to premium tier

## Files Created/Modified:

1. ✅ `billing.html` - Main billing page with payment buttons
2. ✅ `api/create_stripe_session.php` - Creates Stripe checkout sessions
3. ✅ `api/stripe_webhook.php` - Handles Stripe payment confirmations
4. ✅ `api/record_transaction.php` - Records transactions in database
5. ✅ `tbl_transactions` table - Database table for payment records

## Next Steps:

1. **Add Stripe API keys** (see above)
2. **Configure Stripe webhook** (see above)
3. **Test payment flow** end-to-end
4. **Add your crypto wallet address**
5. **Deploy and monitor** transaction logs

## Support:

- Stripe Docs: https://stripe.com/docs/payments/checkout
- Coinbase Commerce: https://commerce.coinbase.com/docs

