# GROK AGENT SETTINGS & CONFIGURATION

## 📍 LOCATION
**File:** `/var/www/html/leadgen/api/openai_chat.php`

## ⚙️ AGENT BEHAVIOR SETTINGS

### 1. RESPONSE STYLE & PERSONALITY
**Location:** Lines 238-250 (`buildRAGReadyPrompt` function)

**Current Settings:**
- **Style:** DIRECT, AGGRESSIVE cannabis expert
- **Max Sentences:** 2 sentences maximum
- **Tone:** Aggressive and confident
- **Personalization:** Uses user's name
- **No Fluff:** No pleasantries, no questions at end

**To Change:**
Edit the system prompt in `buildRAGReadyPrompt()` function:
```php
$system_prompt = "You are a DIRECT, AGGRESSIVE cannabis expert...";
```

### 2. GROK API SETTINGS
**Location:** Lines 797-808

**Current Settings:**
```php
$grok_model = 'grok-4-fast-reasoning';  // Model name
$payload = [
    'model' => $grok_model,
    'messages' => $messages,
    'max_tokens' => 150,        // Response length limit
    'temperature' => 0.9,       // Creativity/assertiveness (0.0-1.0)
    'stream' => false           // Streaming disabled
];
```

**Settings Explained:**
- **`max_tokens`:** Maximum response length (150 = ~2 sentences)
  - Increase for longer responses (e.g., 300, 500)
- **`temperature`:** Controls randomness/creativity
  - 0.0 = Very focused, deterministic
  - 0.9 = More creative, assertive (current)
  - 1.0 = Maximum creativity
- **`model`:** Grok model version
  - `grok-4-fast-reasoning` (current)
  - Other options: `grok-beta`, `grok-2-1212`

**To Change:**
Edit lines 800, 805-807 in `openai_chat.php`

### 3. RAG CONTEXT SETTINGS
**Location:** Lines 269-274 (`buildRAGReadyPrompt` function)

**Current Behavior:**
- RAG context is automatically included when available
- Context comes from Python RAG system (top 5 chunks)
- Includes source citations

**To Change:**
Modify how RAG context is formatted in `buildRAGReadyPrompt()`:
```php
if ($rag_context !== null && !empty($rag_context)) {
    $system_prompt .= "=== RELEVANT KNOWLEDGE BASE CONTEXT (RAG) ===\n";
    $system_prompt .= "$rag_context\n\n";
    // Add custom formatting here
}
```

**RAG Bridge Settings:**
**Location:** `/var/www/html/leadgen/api/rag_bridge.php` (Line 44)
```php
'k' => 5  // Number of chunks to retrieve (top 5)
```
Change `k` to retrieve more/fewer chunks.

### 4. SURVEY INSIGHTS SETTINGS
**Location:** Lines 255-262 (`buildRAGReadyPrompt` function)

**Current Behavior:**
- Only crucial, profit-focused insights are included
- Insights extracted by `extractCrucialSurveyInsights()` function

**To Change:**
Modify `extractCrucialSurveyInsights()` function (around line 400) to:
- Include more/less insights
- Change insight format
- Add custom insight extraction logic

### 5. TOKEN LIMITS (Monetization)
**Location:** Lines 813-826

**Current Tiers:**
```php
$token_tiers = [
    'free' => [
        'max_tokens' => 500,      // Limited access
    ],
    'engaged' => [
        'max_tokens' => 2000,     // 1 offer completed
    ],
    'premium' => [
        'max_tokens' => 10000,    // 2+ offers completed
    ]
];
```

**To Change:**
Edit token limits for each tier in `$token_tiers` array.

### 6. RATE LIMITING
**Location:** Lines 828-831

**Current Settings:**
```php
$max_global_requests_per_minute = 200;
$max_global_tokens_per_minute = 10000;
```

**To Change:**
Modify these values to adjust rate limits.

## 📝 EXAMPLE: WHAT GROK RECEIVES

### System Prompt Structure:
1. **Core Personality** (Lines 238-250)
2. **Crucial Survey Insights** (Lines 255-262)
3. **RAG Context** (Lines 269-274)
4. **Conversation History** (Lines 287-300)
5. **Response Examples** (Lines 305-311)
6. **Current Message** (Lines 316-318)

### User Message:
- Direct question from user
- Added to messages array as `role: 'user'`

### Full Payload:
```json
{
  "model": "grok-4-fast-reasoning",
  "messages": [
    {"role": "system", "content": "[FULL SYSTEM PROMPT]"},
    {"role": "user", "content": "[USER QUESTION]"}
  ],
  "max_tokens": 150,
  "temperature": 0.9,
  "stream": false
}
```

## 🔧 QUICK REFERENCE: COMMON CHANGES

### Make responses longer:
```php
'max_tokens' => 300,  // Line 805
```

### Make responses less aggressive:
```php
'temperature' => 0.7,  // Line 806
// Also edit system prompt line 238: "You are a HELPFUL cannabis expert..."
```

### Include more RAG chunks:
```php
// In rag_bridge.php line 44:
'k' => 10  // Instead of 5
```

### Change response style:
```php
// Line 241: Change "MAXIMUM 2 SENTENCES" to "MAXIMUM 3 SENTENCES"
// Line 238: Change "AGGRESSIVE" to "HELPFUL" or "PROFESSIONAL"
```

## 📍 FILE LOCATIONS SUMMARY

| Setting | File | Line Range |
|---------|------|------------|
| Response Style | `api/openai_chat.php` | 238-250 |
| Grok API Config | `api/openai_chat.php` | 797-808 |
| RAG Context | `api/openai_chat.php` | 269-274 |
| RAG Chunk Count | `api/rag_bridge.php` | 44 |
| Survey Insights | `api/openai_chat.php` | 255-262 |
| Token Limits | `api/openai_chat.php` | 813-826 |
| Rate Limits | `api/openai_chat.php` | 828-831 |

