# 📖 Admin Dashboard Guide

Complete guide for managing the LoudCannabis Lead Generation Platform admin dashboard.

## 🔐 Accessing the Admin Dashboard

**URL:** `https://deepleafai.com/admin_dashboard.html`

**Login Required:** Yes (Admin session required)

**Login Page:** `https://deepleafai.com/admin/login.php`

---

## 📊 Dashboard Overview

The admin dashboard provides comprehensive management tools for:
- **Affiliates** - Manage affiliate accounts and track performance
- **Sponsors** - Manage sponsor companies and their offers
- **Offers** - Manage individual offers and track conversions
- **Tracking** - Monitor clicks, conversions, and revenue
- **Reports** - View analytics and performance metrics

---

## 🎯 Overview Tab

The Overview tab displays 6 key metrics:

1. **Total Affiliates** - Click to view Affiliates tab
2. **Total Sponsors** - Click to view Sponsors tab
3. **Active Offers** - Click to view Offers tab
4. **Total Conversions** - Click to view Tracking tab
5. **Today's Clicks** - Click to view Tracking tab
6. **Total Revenue** - Click to view Reports tab

**Features:**
- Real-time updates every 10 seconds
- Visual indicators when values change
- Clickable cards for quick navigation

---

## 👥 Affiliates Management

### Viewing Affiliates

1. Click **"Affiliates"** tab
2. View list of all affiliates with:
   - Company name / Email
   - Status (active, pending, suspended)
   - Total clicks
   - Conversions
   - Revenue
   - Actions (View, Edit)

### Filtering Affiliates

**Search:** Type in search box to filter by company name, email, or phone

**Status Filter:** Select status from dropdown (All, Active, Pending, Suspended)

**Date Range:** Use date filters to find affiliates by creation date

**Revenue Range:** Filter by minimum/maximum revenue

### Viewing Affiliate Details

1. Click **"👁️ View"** button on any affiliate row
2. View modal shows:
   - Full profile information
   - Performance statistics
   - Activity history
   - Associated offers
   - Status change history

### Editing Affiliates

1. Click **"✏️ Edit"** button on any affiliate row
2. Update fields:
   - Email
   - Company name
   - Phone
   - Status (with optional reason)
   - Payment method
   - Payment details
3. Click **"Save Changes"**

**Status Change Reasons:**
- Optional field when changing status
- Stored in status history
- Helps track why status was changed

### Bulk Actions

1. Select affiliates using checkboxes
2. Choose action:
   - **Activate Selected** - Set status to 'active'
   - **Suspend Selected** - Set status to 'suspended'
   - **Clear Selection** - Deselect all

### Adding New Affiliates

Currently managed through affiliate registration system. Admin can edit existing affiliates.

### Status Management

**Statuses:**
- **Active** - Affiliate is active and can generate links
- **Pending** - Awaiting approval
- **Suspended** - Temporarily disabled

**Status History:**
- All status changes are tracked
- View history via "View" modal
- Includes who changed it, when, and why

---

## 🏢 Sponsors Management

### Viewing Sponsors

1. Click **"Sponsors"** tab
2. View list of all sponsors with:
   - Sponsor name
   - Contact email
   - Industry
   - Status (active, inactive)
   - Total revenue
   - Offer count
   - Actions (View, Edit)

### Filtering Sponsors

**Search:** Type in search box to filter by name, email, or industry

**Status Filter:** Select status from dropdown (All, Active, Inactive)

**Date Range:** Use date filters to find sponsors by creation date

**Revenue Range:** Filter by minimum/maximum revenue

### Viewing Sponsor Details

1. Click **"👁️ View"** button on any sponsor row
2. View modal shows:
   - Full sponsor information
   - Associated offers
   - Performance metrics
   - Status change history

### Editing Sponsors

1. Click **"✏️ Edit"** button on any sponsor row
2. Update fields:
   - Name
   - Contact email
   - Industry
   - Status (with optional reason)
3. Click **"Save Changes"**

### Adding New Sponsors

1. Click **"➕ Add New Sponsor"** button
2. Fill in form:
   - Sponsor Name (required)
   - Contact Email (required)
   - Industry (optional)
3. Click **"Add Sponsor"**

### Sponsor Offer Count

- Automatically tracked
- Shows in sponsor detail view
- Includes active offer count

---

## 🎯 Offers Management

### Viewing Offers

1. Click **"Offers"** tab
2. View list of all offers with:
   - Offer title
   - Sponsor name
   - Offer type (link, call)
   - Payout amount
   - Total clicks
   - Total conversions
   - Status (active, inactive)
   - Actions (View, Edit)

### Filtering Offers

**Search:** Type in search box to filter by title or description

**Status Filter:** Select status from dropdown (All, Active, Inactive)

**Type Filter:** Filter by offer type (Link, Call)

**Sponsor Filter:** Filter by sponsor

**Payout Range:** Filter by minimum/maximum payout

### Viewing Offer Details

1. Click **"👁️ View"** button on any offer row
2. View modal shows:
   - Full offer information
   - Performance metrics
   - Conversion rates
   - Status change history
   - Daily performance chart

### Editing Offers

1. Click **"✏️ Edit"** button on any offer row
2. Update fields:
   - Title
   - Description
   - Payout amount
   - Offer type
   - Status (with optional reason)
3. Click **"Save Changes"**

### Adding New Offers

1. Click **"➕ Add New Offer"** button
2. Fill in form:
   - Select Sponsor (required)
   - Offer Title (required)
   - Description (optional)
   - Offer Type (Link or Call)
   - Payout Amount (required)
3. Click **"Add Offer"**

### Offer Performance Tracking

**Metrics Available:**
- Total clicks
- Conversions
- Total revenue
- Unique affiliates
- Average conversion value
- Conversion rate

**Time Ranges:**
- Last 7 days
- Last 30 days
- Last 90 days
- Last year

---

## 📈 Tracking Tab

### Viewing Tracking Events

1. Click **"Tracking"** tab
2. View list of all tracking events with:
   - Timestamp
   - Affiliate name
   - Offer title
   - Sponsor name
   - Event type (click, conversion, call_qualified)
   - Revenue amount

### Filtering Tracking Events

**Time Range:** Select from dropdown (Today, Last 7 Days, Last 30 Days, etc.)

**Affiliate Filter:** Filter by specific affiliate

**Sponsor Filter:** Filter by specific sponsor

**Offer Filter:** Filter by specific offer

**Event Type Filter:** Filter by event type

---

## 📊 Reports Tab

### Overview

The Reports tab provides comprehensive analytics with:

1. **Revenue Trends Chart** - Clickable chart showing revenue over time
2. **Key Performance Metrics** - 4 metric cards:
   - Total Revenue
   - Total Clicks
   - Total Conversions
   - Conversion Rate
3. **Top Performing Affiliates Chart** - Clickable chart
4. **Top Performing Offers Chart** - Clickable chart
5. **Daily Activity Chart** - Last 30 days activity
6. **Recent Activity Table** - Latest tracking events

### Time Range Selection

Select time range from dropdown:
- Last 7 Days
- Last 30 Days (default)
- Last 90 Days
- Last Year

### Interactive Charts

All charts and metric cards are clickable:
- Click to navigate to relevant tab
- Automatically applies filters
- Provides detailed view

### Exporting Reports

1. Click **"📊 Export Summary"** button
2. Downloads CSV file with:
   - Summary statistics
   - Top performers
   - Performance metrics

---

## 🔄 Real-Time Updates

### Live Status Indicator

**Location:** Top-right corner of dashboard

**Statuses:**
- **Live** (Green) - Updates working normally
- **Updating...** (Blue) - Currently fetching new data
- **Error** (Red) - Update failed
- **Paused** (Red) - Updates stopped

**Update Intervals:**
- Real-time stats: Every 10 seconds
- Overview stats: Every 30 seconds
- Tab data: Every 60 seconds

### Visual Feedback

- Stat cards highlight when values change
- Smooth animation on updates
- Time since last update displayed

---

## 🔍 Search and Filtering

### Search Functionality

**Available in:**
- Affiliates tab
- Sponsors tab
- Offers tab

**Search Fields:**
- Affiliates: Company name, email, phone
- Sponsors: Name, email, industry
- Offers: Title, description

### Advanced Filtering

**Filters Available:**
- Status
- Date range
- Revenue/payout range
- Type (for offers)
- Sponsor (for offers)

### Pagination

**Features:**
- Navigate between pages
- Change items per page (10, 25, 50, 100)
- Shows current page and total pages
- Previous/Next buttons

---

## 📤 Data Export

### Exporting Data

**Available in:**
- Affiliates tab - Export affiliates data
- Sponsors tab - Export sponsors data
- Offers tab - Export offers data
- Tracking tab - Export tracking events
- Reports tab - Export summary

**Format:** CSV

**Includes:**
- All visible columns
- Current filters applied
- Formatted data

---

## ✅ Bulk Actions

### Affiliate Bulk Actions

1. Select multiple affiliates using checkboxes
2. Choose action:
   - **Activate Selected** - Set all to 'active'
   - **Suspend Selected** - Set all to 'suspended'
3. Confirm action in dialog
4. Status changes are tracked in history

---

## 🎨 User Interface Features

### Responsive Design

**Desktop:**
- Full-width tables
- Side-by-side modals
- Grid layouts

**Tablet:**
- Responsive tables with horizontal scroll
- Stacked modals
- Adjusted grid layouts

**Mobile:**
- Vertical layouts
- Touch-friendly buttons
- Optimized modals

### Loading States

**Visual Indicators:**
- Spinner animations
- Loading overlays
- Button loading states
- Table loading messages

### Confirmation Dialogs

**Triggered for:**
- Status changes
- Deletions
- Bulk actions

**Features:**
- Clear action description
- Cancel option
- Confirmation required

---

## 🔒 Security Features

### Authentication

- Admin session required
- Automatic logout on session expiry
- Secure session management

### CSRF Protection

- All forms protected
- Tokens automatically managed
- Prevents cross-site request forgery

### Rate Limiting

- API calls rate-limited
- Prevents abuse
- Headers show remaining requests

### Input Validation

- Client-side validation
- Server-side validation
- Input sanitization
- SQL injection prevention

---

## 📝 Status Change Management

### Status Change Reasons

When changing status, you can optionally provide a reason:
- Stored in status history
- Helps track why changes were made
- Useful for compliance and debugging

### Status History

**View History:**
1. Click "View" on any affiliate, sponsor, or offer
2. Status history shown in modal
3. Includes:
   - Old status → New status
   - Reason (if provided)
   - Changed by (username)
   - Timestamp

---

## 🎯 Performance Tracking

### Offer Performance

**Metrics Available:**
- Total clicks
- Conversions
- Total revenue
- Unique affiliates
- Average conversion value
- Conversion rate

**Access:**
- Via "View" modal on offer
- Via Reports tab
- Via API endpoint

### Affiliate Performance

**Metrics Available:**
- Total clicks
- Conversions
- Total revenue
- Associated offers

**Access:**
- Via "View" modal on affiliate
- Via Reports tab
- Via API endpoint

---

## 🐛 Troubleshooting

### Dashboard Not Loading

1. Check browser console for errors
2. Verify admin session is active
3. Check network connectivity
4. Refresh page

### Data Not Updating

1. Check real-time indicator status
2. Verify API endpoints are accessible
3. Check browser console for errors
4. Try manual refresh

### Forms Not Submitting

1. Check CSRF token is present
2. Verify all required fields filled
3. Check browser console for errors
4. Try refreshing page

### Charts Not Displaying

1. Check Chart.js is loaded
2. Verify data is available
3. Check browser console for errors
4. Try refreshing page

---

## 💡 Tips and Best Practices

### Managing Affiliates

1. **Regular Reviews:** Periodically review affiliate performance
2. **Status Reasons:** Always provide reasons for status changes
3. **Bulk Actions:** Use bulk actions for efficiency
4. **Export Data:** Export data regularly for backup

### Managing Sponsors

1. **Offer Count:** Monitor offer count per sponsor
2. **Revenue Tracking:** Track sponsor revenue regularly
3. **Status Management:** Keep sponsor statuses up to date

### Managing Offers

1. **Performance Monitoring:** Regularly check offer performance
2. **Status Updates:** Update offer status based on performance
3. **Payout Optimization:** Adjust payouts based on conversion rates

### Using Reports

1. **Time Ranges:** Use appropriate time ranges for analysis
2. **Export Regularly:** Export reports for record keeping
3. **Compare Periods:** Compare different time periods for trends

---

## 📞 Support

For issues or questions:
1. Check this guide first
2. Review API documentation
3. Check browser console for errors
4. Contact development team

---

## 🔄 System Updates

The dashboard automatically:
- Updates stats every 10-60 seconds
- Refreshes data when switching tabs
- Invalidates cache on data changes
- Tracks all status changes

---

**Last Updated:** 2024-01-15
**Dashboard Version:** 1.0

