#!/usr/bin/env python3
"""
WSGI Entry Point for Apts R US AI Rental Application

This file serves as the WSGI callable object for the Flask application,
required for deployment on WSGI-compatible servers like cPanel, Heroku,
or other hosting providers.
"""

import os
import sys

# Add the current directory to Python path
sys.path.insert(0, os.path.dirname(__file__))

# Import the Flask application
from app import app

# Make the Flask app available as a WSGI callable
application = app

if __name__ == "__main__":
    # For local development/testing
    application.run(host='0.0.0.0', port=8000, debug=False)
