# 🚀 Apts R US AI Chat Application - Full Deployment Guide

## 📋 Deployment Overview

This guide will help you deploy the AI rental application to your server at `aptsr-us.com`.

## 🔑 SSH Access Setup

**You have SSH access with the following key:**
- **Server:** aptsr-us.com
- **User:** aptsrusc
- **SSH Key:** Already generated and available

## 📂 Files to Upload

Upload these files to your server:
- `aptrus_ai_deployment.tar.gz` - Complete application package
- `deploy_instructions.sh` - Automated deployment script

## 🛠️ Step-by-Step Deployment

### Step 1: Connect to Your Server
```bash
ssh aptsrusc@aptsr-us.com
```

### Step 2: Extract Existing Configuration (IMPORTANT!)
Before deleting the old website, extract any configuration information:

```bash
# Navigate to current website directory
cd /var/www/html  # or wherever your current site is

# Look for configuration files
find . -name "*.php" -o -name "config*" -o -name "*.ini" -o -name ".env*" | head -20

# Check for email/SMTP configuration
grep -r "smtp\|mail\|email" . --include="*.php" --include="*.js" --include="*.py" | head -20

# Check for database connections
grep -r "mysql\|database\|db_" . --include="*.php" | head -20

# Look for any environment files
find . -name ".env*" -o -name "config.php" -o -name "settings.php"
```

**Save any important configuration information before proceeding!**

### Step 3: Backup Current Website
```bash
# Create backup of current site
sudo cp -r /var/www/html /var/www/html_backup_$(date +%Y%m%d_%H%M%S)

# Also backup any configuration files you found
sudo mkdir -p /root/config_backup
sudo cp -r /etc/nginx/sites-available/aptsrus* /root/config_backup/ 2>/dev/null || true
sudo cp -r /etc/apache2/sites-available/*aptsrus* /root/config_backup/ 2>/dev/null || true
```

### Step 4: Upload New Application
```bash
# Create application directory
sudo mkdir -p /var/www/aptsrus-ai
sudo chown aptsrusc:aptsrusc /var/www/aptsrus-ai

# Upload files (use scp, rsync, or your preferred method)
# From your local machine:
scp aptrus_ai_deployment.tar.gz aptsrusc@aptsr-us.com:~/
scp deploy_instructions.sh aptsrusc@aptsr-us.com:~/

# On server, extract files
cd /var/www/aptsrus-ai
tar -xzf ~/aptrus_ai_deployment.tar.gz
```

### Step 5: Run Deployment Script
```bash
# Make deployment script executable
chmod +x ~/deploy_instructions.sh

# Run deployment
~/deploy_instructions.sh
```

### Step 6: Configure Environment Variables
```bash
cd /var/www/aptsrus-ai

# Edit the .env file with your actual credentials
nano .env

# Add these required variables:
GROK_API_KEY=your_actual_grok_api_key_here
FLASK_SECRET_KEY=your_random_secret_key_here

# Add email configuration (if you found SMTP settings from old site):
SMTP_SERVER=smtp.gmail.com  # or whatever you found
SMTP_PORT=587
SMTP_USERNAME=your-email@gmail.com
SMTP_PASSWORD=your-app-password
FROM_EMAIL=applications@aptsrus.com
```

### Step 7: Test the Application
```bash
# Check if services are running
sudo supervisorctl status aptsrus-ai
sudo systemctl status nginx

# Test the application
curl http://localhost:8000
curl http://aptsr-us.com
```

### Step 8: Set Up SSL (Recommended)
```bash
# Install certbot for Let's Encrypt
sudo apt install certbot python3-certbot-nginx

# Get SSL certificate
sudo certbot --nginx -d aptsr-us.com -d www.aptsr-us.com
```

## 🔧 Manual Configuration (If Automated Script Fails)

If the automated script doesn't work, follow these manual steps:

### Python Setup
```bash
cd /var/www/aptsrus-ai
python3 -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

### Gunicorn Setup
```bash
# Install gunicorn
pip install gunicorn

# Create gunicorn config
cat > gunicorn.conf.py << EOF
bind = "127.0.0.1:8000"
workers = 3
worker_class = "sync"
worker_connections = 1000
timeout = 30
keepalive = 2
user = "aptsrusc"
group = "aptsrusc"
tmp_upload_dir = None
EOF
```

### Supervisor Setup
```bash
sudo apt install supervisor

# Create supervisor config
sudo tee /etc/supervisor/conf.d/aptsrus-ai.conf > /dev/null << EOF
[program:aptsrus-ai]
directory=/var/www/aptsrus-ai
command=/var/www/aptsrus-ai/venv/bin/gunicorn --config gunicorn.conf.py app:app
autostart=true
autorestart=true
redirect_stderr=true
stdout_logfile=/var/log/aptsrus-ai.log
stderr_logfile=/var/log/aptsrus-ai-error.log
environment=PATH="/var/www/aptsrus-ai/venv/bin"
user=aptsrusc
EOF

# Reload supervisor
sudo supervisorctl reread
sudo supervisorctl update
sudo supervisorctl start aptsrus-ai
```

### Nginx Setup
```bash
sudo apt install nginx

# Create nginx config
sudo tee /etc/nginx/sites-available/aptsrus-ai > /dev/null << EOF
server {
    listen 80;
    server_name aptsr-us.com www.aptsr-us.com;

    location = /favicon.ico { access_log off; log_not_found off; }

    location / {
        include proxy_params;
        proxy_pass http://127.0.0.1:8000;
        proxy_set_header X-Forwarded-For \$proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto \$scheme;
        proxy_set_header X-Real-IP \$remote_addr;
        proxy_set_header Host \$http_host;
    }
}
EOF

# Enable site
sudo ln -sf /etc/nginx/sites-available/aptsrus-ai /etc/nginx/sites-enabled/
sudo rm -f /etc/nginx/sites-enabled/default
sudo nginx -t
sudo systemctl restart nginx
```

## 🔍 Troubleshooting

### Check Application Logs
```bash
tail -f /var/log/aptsrus-ai.log
tail -f /var/log/aptsrus-ai-error.log
```

### Check Nginx Logs
```bash
tail -f /var/log/nginx/error.log
tail -f /var/log/nginx/access.log
```

### Restart Services
```bash
sudo supervisorctl restart aptsrus-ai
sudo systemctl reload nginx
```

### Test Application Directly
```bash
cd /var/www/aptsrus-ai
source venv/bin/activate
python3 app.py
# Then visit http://localhost:5000
```

## 📊 Post-Deployment Checklist

- [ ] Application accessible at https://aptsr-us.com
- [ ] SSL certificate installed
- [ ] Email notifications configured
- [ ] Grok API key added
- [ ] CSV storage working
- [ ] Old website backed up
- [ ] Services auto-start on boot

## 🔒 Security Notes

- Change default passwords
- Keep SSH keys secure
- Regularly update system packages
- Monitor logs for suspicious activity
- Use strong firewall rules

## 📞 Support

If you encounter issues:
1. Check the logs (commands above)
2. Verify all environment variables are set
3. Ensure all dependencies are installed
4. Test the application locally first

The application should be fully functional once deployed! 🚀
