# 🏠 Apts R US - AI Rental Application System

A modern, AI-powered rental application system that integrates with Grok API to provide an interactive chat experience for rental applications. Features a stunning graphical interface with animations and a complete backend for processing applications.

## ✨ Features

- 🤖 **AI-Powered Chat Agent** using Grok API
- 🎨 **Modern Graphical Interface** with animations and visual effects
- 📱 **Responsive Design** that works on all devices
- ✅ **No Credit Check Guarantee** - Approves everyone
- 💰 **Simple $500 Deposit Process**
- 📧 **Admin Notifications** for new applications
- 💾 **Application Data Storage** in JSON format
- 🔒 **Secure Session Management**
- ⚡ **Real-time Chat** with typing indicators

## 🚀 Quick Start

### Prerequisites

- Python 3.8+
- Grok API Key (from x.ai)

### Installation

1. **Clone or download the project files**

2. **Install dependencies:**
   ```bash
   pip install -r requirements.txt
   ```

3. **Configure environment variables:**
   ```bash
   cp env_template.txt .env
   ```
   Edit `.env` and add your Grok API key:
   ```
   GROK_API_KEY=xai-bYupNvIKS2S5I41aDUOKj7XSzoIitscspt9HvhesX0wK58Bnggck8gPAbK1jXvgc7PzKZJntt8HIheqE
   FLASK_SECRET_KEY=some_random_secret_key_here
   ```

4. **Run the application:**
   ```bash
python app.py
```

### Alternative Startup Methods

**Using WSGI (Production):**
```bash
# For production servers (cPanel, etc.)
gunicorn --bind 0.0.0.0:8000 wsgi:application
```

**Using run.py script:**
```bash
python run.py
```

5. **Open your browser** and navigate to `http://localhost:5000`

## 📁 Project Structure

```
aptrus_ai/
├── app.py                 # Main Flask application
├── wsgi.py                # WSGI entry point for production deployment
├── run.py                 # Alternative startup script for development
├── requirements.txt       # Python dependencies
├── env_template.txt       # Environment configuration template
├── README.md             # This file
├── templates/
│   └── index.html        # Main web interface
├── applications/         # Application data storage (auto-created)
└── venv/                 # Python virtual environment (created during setup)
```

## 🎯 How It Works

### AI Assistant Role
The AI assistant is programmed to be:
- **Extremely encouraging** and positive
- **Guarantee-focused** - emphasizes "we approve everyone"
- **Step-by-step guide** through the application process
- **Data validator** - ensures information quality
- **Professional yet friendly** communication style

### For Applicants:
1. **Start Application** - Click the "Start New Application" button
2. **AI-Guided Chat** - Answer questions about property and personal info
3. **Smart Data Extraction** - AI analyzes conversation to extract structured data
4. **Submit Application** - Complete process with email notification

### For Admins:
- **CSV Storage**: All applications saved to `applications/all_applications.csv`
- **Email Notifications**: Instant alerts when applications are submitted
- **JSON Backup**: Individual application files for reference
- **Unique Tracking**: Each application has an ID for easy management

## 🎨 Interface Highlights

- **Animated Background** with floating particles
- **Gradient Designs** with modern color schemes
- **Interactive Elements** with hover effects and animations
- **Status Indicators** showing chat activity
- **Responsive Layout** that adapts to all screen sizes
- **Visual Feedback** for all user interactions

## 🔧 Configuration

### Environment Variables

| Variable | Description | Required |
|----------|-------------|----------|
| `GROK_API_KEY` | Your Grok API key from x.ai | Yes |
| `FLASK_SECRET_KEY` | Random secret key for sessions | Yes |
| `ADMIN_EMAIL` | Email for admin notifications | No |
| `SMTP_SERVER` | SMTP server (e.g., smtp.gmail.com) | No |
| `SMTP_PORT` | SMTP port (default: 587) | No |
| `SMTP_USERNAME` | SMTP username/email | No |
| `SMTP_PASSWORD` | SMTP password or app password | No |
| `FROM_EMAIL` | From email address for notifications | No |

### Customization

The interface can be customized by editing `templates/index.html`:
- Colors and gradients in the CSS section
- Animation timings and effects
- Chat bubble styling
- Background particle effects

## 📊 Application Data Structure & Storage

### Data Collection
Each application collects:
- **Property Information**: Apartment name/link, lease duration, move-in date, unit details
- **Contact Information**: Full name, email, phone (required)
- **Occupant Information**: Number of adults and children
- **Emergency Contact**: Optional backup contact details
- **Parking Information**: Vehicle details if parking is needed
- **Application Metadata**: ID, date, status

### Storage Locations
- **Primary**: `applications/all_applications.csv` - Master CSV file with all applications
- **Backup**: `applications/{application_id}.json` - Individual JSON files for reference
- **Email**: Automatic notifications sent to admin email when applications are submitted

### CSV Format
The CSV file includes headers and all application data in tabular format for easy analysis and import into other systems.

## 🛠️ Backend Features

- **Flask Web Framework** for the web server
- **Session Management** for chat persistence
- **Grok API Integration** for AI responses
- **Data Validation** and error handling
- **File-based Storage** for applications
- **Logging** for debugging and monitoring

## 🔒 Security Considerations

- Input validation and sanitization
- Secure session handling
- API key protection via environment variables
- CORS protection
- Rate limiting ready for production

## 🚀 Production Deployment

### WSGI Deployment Setup

**For WSGI-compatible servers (cPanel, Heroku, etc.):**
- Use `wsgi.py` as the application entry point
- Configure your server to call `wsgi:application`
- Example: `gunicorn --bind 0.0.0.0:8000 wsgi:application`

### Production Deployment Steps

For production deployment:

1. **WSGI Configuration:**
   - Point your server to `wsgi.py`
   - Ensure `application = app` is available as WSGI callable

2. **Server Setup:**
   - Set up a reverse proxy (nginx, Apache)
   - Configure environment variables from `.env` file
   - Ensure proper file permissions (755 for directories, 644 for files)

3. **Database & Services:**
   - Use a database instead of CSV file storage
   - Implement proper email service (SendGrid, AWS SES)
   - Add SSL/TLS certificates
   - Set up proper logging and monitoring

4. **cPanel Specific Setup:**
   - Use cPanel's Python Application Manager
   - Set startup file to `wsgi.py`
   - Configure domain and environment variables
   - Set up application URL and document root

## 📞 Support

- **Phone:** (555) 123-4567
- **Email:** info@aptsrus.com
- **Hours:** Monday - Friday, 9 AM - 6 PM

## 📋 Business Logic

The system is designed around Apts R US's unique selling points:
- **Zero Rejections:** All applicants are approved
- **Simple Process:** $500 deposit starts everything
- **Fast Processing:** 7-10 day review period
- **Network Advantage:** Works with private owners nationwide

## 🎉 Success Metrics

The graphical interface helps achieve:
- Higher conversion rates through visual appeal
- Better user engagement with interactive elements
- Professional appearance that builds trust
- Mobile-friendly experience for on-the-go applicants

---

**Built with ❤️ for Apts R US - Making renting simple and accessible for everyone!**
