#!/usr/bin/env python3
"""
Application Startup Script for Apts R US AI Rental Application

This script serves as an alternative entry point for running the application
locally or in development environments.
"""

import os
from app import app

if __name__ == "__main__":
    # Get port from environment or default to 5000
    port = int(os.environ.get('PORT', 5000))

    # Run the application
    app.run(
        host='0.0.0.0',
        port=port,
        debug=os.environ.get('FLASK_DEBUG', 'False').lower() == 'true'
    )
