# 🚀 cPanel WSGI Deployment Guide for Apts R US AI Application

## 📋 WSGI Files Created

Your application now includes proper WSGI configuration:

- **`wsgi.py`** - WSGI entry point (production servers)
- **`run.py`** - Alternative startup script (development)
- **WSGI callable:** `application = app` (ready for cPanel)

## 🎯 cPanel Python Application Setup

### Step 1: Access cPanel Python Manager

1. Log in to your cPanel dashboard
2. Navigate to **Software** → **Setup Python App**
3. Click **Create Application**

### Step 2: Configure Python Application

**Application Configuration:**
- **Python Version:** 3.8 or higher (choose latest available)
- **Application Root:** `/home/aptsrusc/public_html/aptrus_ai`
- **Application URL:** Choose your domain/subdomain
- **Startup File:** `wsgi.py`
- **Application Entry Point:** `application` (leave blank, it will use the WSGI callable)
- **Passenger Log File:** `/home/aptsrusc/logs/passenger.log`

**Environment Variables:**
Add these environment variables:
```
GROK_API_KEY=xai-bYupNvIKS2S5I41aDUOKj7XSzoIitscspt9HvhesX0wK58Bnggck8gPAbK1jXvgc7PzKZJntt8HIheqE
FLASK_SECRET_KEY=your_random_secret_key_here
FLASK_ENV=production
```

### Step 3: Upload Application Files

**Option A: Via cPanel File Manager**
1. Go to **Files** → **File Manager**
2. Navigate to `public_html/`
3. Upload `aptrus_ai_deployment_final.tar.gz`
4. Extract the archive
5. Ensure files are in `public_html/aptrus_ai/`

**Option B: Via SSH (if available)**
```bash
cd /home/aptsrusc/public_html
wget https://your-domain.com/aptrus_ai_deployment_final.tar.gz
tar -xzf aptrus_ai_deployment_final.tar.gz
```

### Step 4: Install Dependencies

In cPanel Python Manager:
1. Go to your application
2. Click **Run Pip Install** or use the terminal
3. Install from `requirements.txt`:
   ```
   pip install -r requirements.txt
   ```

### Step 5: Configure File Permissions

Set proper permissions:
```bash
chmod -R 755 /home/aptsrusc/public_html/aptrus_ai/
chmod 644 /home/aptsrusc/public_html/aptrus_ai/.env
```

### Step 6: Restart Application

In cPanel Python Manager:
1. Click **Restart** for your application
2. Check the logs for any errors
3. Visit your application URL to test

## 🔧 Alternative: Manual WSGI Setup

If cPanel's Python Manager doesn't work:

### Create .htaccess for WSGI
```apache
# .htaccess in public_html/aptrus_ai/
Options +ExecCGI
AddHandler wsgi-script .py
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteRule ^(.*)$ wsgi.py/$1 [QSA,PT,L]
```

### Configure Passenger (if available)
Create `passenger_wsgi.py`:
```python
import sys
import os
sys.path.insert(0, os.path.dirname(__file__))

from wsgi import application
```

## 🧪 Testing Your Deployment

### Test WSGI Callable
```bash
cd /home/aptsrusc/public_html/aptrus_ai
python3 -c "from wsgi import application; print('WSGI callable works!')"
```

### Check Application Logs
```bash
tail -f /home/aptsrusc/logs/passenger.log
tail -f /home/aptsrusc/public_html/aptrus_ai/logs/application.log
```

### Test Web Access
- Visit your configured application URL
- Check that the AI interface loads
- Test the chat functionality

## 📊 File Structure After Deployment

```
/home/aptsrusc/public_html/aptrus_ai/
├── app.py                 # Flask application
├── wsgi.py               # WSGI entry point ✅
├── run.py                # Alternative startup
├── requirements.txt      # Dependencies
├── .env                  # Environment variables
├── templates/
│   └── index.html        # Web interface
├── applications/         # Data storage (created automatically)
├── venv/                 # Virtual environment
└── __pycache__/          # Python cache
```

## 🔧 Troubleshooting

### Common Issues:

**WSGI Import Error:**
- Ensure `wsgi.py` has correct imports
- Check Python path in WSGI file

**Module Not Found:**
- Verify virtual environment is activated
- Check if dependencies are installed

**Permission Errors:**
- Ensure files have correct permissions (755/644)
- Check ownership matches cPanel user

**Application Won't Start:**
- Check passenger logs
- Verify WSGI callable is properly defined
- Test with `python3 wsgi.py` locally

### Debug Commands:
```bash
# Test WSGI directly
cd /home/aptsrusc/public_html/aptrus_ai
python3 wsgi.py

# Check Python version
python3 --version

# List installed packages
pip list

# Check environment variables
env | grep -E "(FLASK|GROK)"
```

## 📞 Support

If deployment issues persist:
1. Check cPanel error logs
2. Verify all files were uploaded correctly
3. Ensure Python version compatibility
4. Contact your hosting provider for WSGI support

## ✅ Success Indicators

- ✅ Application URL loads without errors
- ✅ Beautiful AI interface displays
- ✅ Chat functionality works
- ✅ No 500/404 errors in logs
- ✅ CSV files created in applications/ directory

**Your Apts R US AI application should now be live with full WSGI support!** 🎉
