
import sys
import os
import pandas as pd
from universal_backtesting import UniversalBacktestingEngine

def test_dynamic_strategy():
    print("🚀 Testing Dynamic Strategy Engine...")
    
    engine = UniversalBacktestingEngine()
    
    # Define a simple dynamic strategy code
    strategy_code = """
import pandas as pd
import numpy as np

def generate_signals(df: pd.DataFrame, params: dict) -> pd.DataFrame:
    # Simple SMA Crossover
    short_window = params.get('short_window', 10)
    long_window = params.get('long_window', 50)
    
    df['short_mavg'] = df['close'].rolling(window=short_window, min_periods=1).mean()
    df['long_mavg'] = df['close'].rolling(window=long_window, min_periods=1).mean()
    
    df['signal'] = 0
    df.loc[df['short_mavg'] > df['long_mavg'], 'signal'] = 1
    df.loc[df['short_mavg'] < df['long_mavg'], 'signal'] = -1
    
    return df
"""

    # Parameters
    params = {
        'stake': 1000,
        'short_window': 5,
        'long_window': 20
    }
    
    # Run backtest on crypto with specific file
    print("📊 Running backtest with dynamic code on BTCUSD...")
    result = engine.run_backtest(
        market='crypto',
        strategy_name='dynamic_custom',
        parameters={**params, 'data_file': 'data/csv/BTCUSD_1hour_ohlc.csv'},
        strategy_code=strategy_code,
        min_trades=1,
        timeframe='1hour'
    )
    
    if 'error' in result:
        print(f"❌ Test Failed: {result['error']}")
        if 'details' in result:
            print(f"Details: {result['details']}")
    else:
        print("✅ Test Passed!")
        print(f"Total Trades: {result['total_trades']}")
        print(f"Total Profit: ${result['results']['total_profit']}")
        print(f"Win Rate: {result['results']['win_rate']}%")
        
        # Verify trades structure
        if len(result['trades']) > 0:
            print("Sample Trade:", result['trades'][0])

if __name__ == "__main__":
    test_dynamic_strategy()
