const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

async function test() {
  try {
    const result = await prisma.systemAnalytics.create({
      data: {
        eventType: 'ANNOUNCEMENT',
        eventData: JSON.stringify({
          title: 'Welcome to EventheOdds.ai!',
          content: 'We are excited to launch our platform!',
          type: 'feature',
          important: true,
          published: true,
          date: '2024-12-24'
        }),
        metadata: JSON.stringify({ createdBy: 'admin' }),
      },
    });
    console.log('Created announcement:', result.id);
  } catch (e) {
    console.error('Error:', e.message);
    console.error('Stack:', e.stack);
  }
  await prisma.$disconnect();
}
test();
