export interface Strategy {
  id: string;
  name: string;
  description: string;
  domain: 'sports' | 'crypto' | 'stocks' | 'forex';
  code: string;
  tags: string[];
  isPublic: boolean;
  authorId: string;
  authorName: string;
  createdAt: Date;
  updatedAt: Date;
  version: number;
  parentStrategyId?: string; // For forked strategies

  // Metadata
  riskLevel: 'low' | 'medium' | 'high';
  timeHorizon: 'short' | 'medium' | 'long';
  expectedReturn: number;
  successRate?: number; // Will be populated from historical testing

  // Social features
  likes: number;
  forks: number;
  comments: StrategyComment[];
  ratings: StrategyRating[];

  // AI-generated metadata
  aiDescription?: string;
  suggestedImprovements?: string[];
  relatedStrategies?: string[];
}

export interface StrategyComment {
  id: string;
  strategyId: string;
  authorId: string;
  authorName: string;
  content: string;
  createdAt: Date;
  updatedAt?: Date;
  likes: number;
  replies: StrategyComment[];
}

export interface StrategyRating {
  userId: string;
  rating: 1 | 2 | 3 | 4 | 5;
  comment?: string;
  createdAt: Date;
}

export interface StrategyCollection {
  id: string;
  name: string;
  description: string;
  authorId: string;
  isPublic: boolean;
  strategies: string[]; // Strategy IDs
  tags: string[];
  createdAt: Date;
  updatedAt: Date;
  followers: number;
}

export interface StrategyTemplate {
  id: string;
  name: string;
  description: string;
  domain: 'sports' | 'crypto' | 'stocks' | 'forex';
  category: string;
  difficulty: 'beginner' | 'intermediate' | 'advanced';
  code: string;
  placeholders: Record<string, string>; // Variables to customize
  preview: string; // Generated strategy preview
}

export interface StrategySearchFilters {
  domain?: ('sports' | 'crypto' | 'stocks' | 'forex')[];
  tags?: string[];
  author?: string;
  riskLevel?: ('low' | 'medium' | 'high')[];
  timeHorizon?: ('short' | 'medium' | 'long')[];
  isPublic?: boolean;
  minRating?: number;
  sortBy?: 'newest' | 'oldest' | 'popular' | 'rating' | 'forks';
  searchQuery?: string;
}

export interface StrategyStats {
  totalStrategies: number;
  publicStrategies: number;
  totalUsers: number;
  popularTags: Array<{ tag: string; count: number }>;
  domainDistribution: Record<string, number>;
  recentActivity: Array<{
    type: 'created' | 'forked' | 'liked' | 'commented';
    strategyId: string;
    strategyName: string;
    userId: string;
    userName: string;
    timestamp: Date;
  }>;
}

