import { NextResponse } from 'next/server';

/**
 * Edge-safe security headers helper.
 *
 * IMPORTANT: Do not import server-only modules here (DB, crypto, fs, etc).
 * This file is safe to use from Next.js Middleware.
 */
export function addSecurityHeaders(response: NextResponse): NextResponse {
  // Security headers
  response.headers.set('X-Content-Type-Options', 'nosniff');
  response.headers.set('X-Frame-Options', 'DENY');
  response.headers.set('X-XSS-Protection', '1; mode=block');
  response.headers.set('Referrer-Policy', 'strict-origin-when-cross-origin');
  response.headers.set('Permissions-Policy', 'geolocation=(), microphone=(), camera=()');

  // CORS headers for production domains
  response.headers.set(
    'Access-Control-Allow-Origin',
    process.env.NODE_ENV === 'production'
      ? process.env.ALLOWED_ORIGINS || 'https://eventheodds.ai'
      : '*'
  );
  response.headers.set('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
  response.headers.set('Access-Control-Allow-Headers', 'Content-Type, Authorization');
  response.headers.set('Access-Control-Max-Age', '86400');

  return response;
}




