export interface UserProfile {
  id: string;
  createdAt: Date;
  lastActive: Date;

  // Demographics & Preferences
  preferredMarkets: ('sports' | 'crypto' | 'stocks' | 'forex')[];
  riskTolerance: 'low' | 'medium' | 'high';
  experienceLevel: 'beginner' | 'intermediate' | 'advanced';
  favoriteStrategies: string[];
  successfulStrategies: StrategyMemory[];
  failedStrategies: StrategyMemory[];

  // Behavioral Patterns
  sessionFrequency: number; // sessions per week
  averageSessionDuration: number; // minutes
  preferredDomains: Record<string, number>; // usage counts
  timePreferences: {
    activeHours: number[];
    timezone: string;
  };

  // Learning & Adaptation
  learningGoals: string[];
  knowledgeGaps: string[];
  recommendedStrategies: string[];
  feedbackHistory: UserFeedback[];
}

export interface StrategyMemory {
  strategyId: string;
  name: string;
  domain: string;
  code: string;
  performance: {
    winRate: number;
    totalTrades: number;
    netProfit: number;
    createdAt: Date;
  };
  context: {
    userPrompt: string;
    marketConditions: string;
    successFactors: string[];
  };
  usageCount: number;
  lastUsed: Date;
}

export interface ConversationMemory {
  id: string;
  userId: string;
  sessionId: string;
  timestamp: Date;
  role: 'user' | 'assistant';
  content: string;
  strategyGenerated?: {
    code: string;
    name: string;
    performance?: any;
  };
  ragContext?: {
    insights: string[];
    sources: string[];
  };
}

export interface ConversationSummary {
  id: string;
  userId: string;
  sessionId: string;
  summary: string;
  keyTopics: string[];
  strategiesDiscussed: string[];
  insightsLearned: string[];
  createdAt: Date;
  vectorEmbedding?: number[]; // For semantic search
}

export interface UserFeedback {
  id: string;
  timestamp: Date;
  type: 'strategy_rating' | 'feature_request' | 'bug_report' | 'general_feedback';
  content: string;
  rating?: number; // 1-5
  context: {
    strategyId?: string;
    sessionId?: string;
    market?: string;
  };
}

export interface MemoryContext {
  userProfile: Partial<UserProfile>;
  recentConversations: ConversationMemory[];
  relevantStrategies: StrategyMemory[];
  conversationSummaries: ConversationSummary[];
  marketInsights: string[];
  personalization: {
    preferredDomain: string;
    riskAdjusted: boolean;
    experienceLevel: string;
  };
}

