import { CryptoSnapshot } from './types';

const COINGECKO_URL =
  'https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum&vs_currencies=usd';

export async function fetchCryptoSnapshot(): Promise<CryptoSnapshot[]> {
  try {
    const response = await fetch(COINGECKO_URL, {
      headers: {
        Accept: 'application/json',
      },
      next: { revalidate: 300 },
    });

    if (!response.ok) {
      throw new Error(`Bad response ${response.status}`);
    }

    const payload = (await response.json()) as Record<
      string,
      { usd: number }
    >;

    return Object.entries(payload).map(([asset, price]) => ({
      asset,
      priceUsd: price.usd,
      fetchedAt: new Date().toISOString(),
      source: 'coingecko',
    }));
  } catch (error) {
    console.warn('Falling back to cached snapshot', error);
    return [
      {
        asset: 'bitcoin',
        priceUsd: 97000,
        fetchedAt: new Date().toISOString(),
        source: 'cache',
      },
      {
        asset: 'ethereum',
        priceUsd: 5050,
        fetchedAt: new Date().toISOString(),
        source: 'cache',
      },
    ];
  }
}

