export interface DataSource {
  id: string;
  name: string;
  type: 'csv' | 'api' | 'database';
  domain: 'sports' | 'crypto' | 'stocks' | 'forex';
  endpoint?: string;
  filePath?: string;
  schedule?: string; // cron expression
  lastUpdated?: Date;
  recordCount?: number;
  status: 'active' | 'inactive' | 'error';
  config: DataSourceConfig;
}

export interface DataSourceConfig {
  delimiter?: string;
  hasHeaders?: boolean;
  dateFormat?: string;
  encoding?: string;
  apiKey?: string;
  headers?: Record<string, string>;
  rateLimit?: number;
  timeout?: number;
  retryAttempts?: number;
  schemaValidation?: boolean;
  transformations?: DataTransformation[];
}

export interface DataTransformation {
  field: string;
  operation: 'rename' | 'cast' | 'transform' | 'validate' | 'filter';
  config: any;
}

export interface IngestionResult {
  sourceId: string;
  success: boolean;
  recordsProcessed: number;
  recordsInserted: number;
  recordsUpdated: number;
  recordsFailed: number;
  errors: string[];
  duration: number;
  timestamp: Date;
}

export interface DataQualityMetrics {
  sourceId: string;
  totalRecords: number;
  duplicateRecords: number;
  invalidRecords: number;
  missingValues: Record<string, number>;
  dataCompleteness: number; // 0-1
  lastCheck: Date;
  issues: DataQualityIssue[];
}

export interface DataQualityIssue {
  type: 'missing_values' | 'invalid_format' | 'duplicates' | 'outliers' | 'stale_data';
  severity: 'low' | 'medium' | 'high' | 'critical';
  field?: string;
  description: string;
  affectedRecords: number;
  suggestedAction?: string;
}

export interface DataVersion {
  id: string;
  sourceId: string;
  version: number;
  timestamp: Date;
  recordCount: number;
  checksum: string;
  changes: {
    inserted: number;
    updated: number;
    deleted: number;
  };
  metadata: Record<string, any>;
}

