'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { BarChart3, Bot, Database, Home, Settings, Terminal } from 'lucide-react';

import { cn } from '@/lib/utils';

const navigation = [
  { name: 'Overview', href: '/admin', icon: Home },
  { name: 'AI Sport Guru', href: '/admin/ai-guru', icon: Bot },
  { name: 'Data Manager', href: '/admin/data', icon: Database },
  { name: 'Strategy Runs', href: '/admin/strategies', icon: Terminal },
  { name: 'Analytics', href: '/admin/analytics', icon: BarChart3 },
  { name: 'Settings', href: '/admin/settings', icon: Settings },
];

export function AdminSidebar() {
  const pathname = usePathname();

  return (
    <div className="flex h-full w-64 flex-col border-r border-white/10 bg-slate-950 text-slate-300">
      <div className="flex h-16 items-center px-6">
        <span className="text-lg font-bold tracking-wider text-white">
          LG<span className="text-blue-500">Backtest</span> Admin
        </span>
      </div>
      <nav className="flex-1 space-y-1 px-3 py-4">
        {navigation.map((item) => {
          const isActive = pathname === item.href;
          return (
            <Link
              key={item.name}
              href={item.href}
              className={cn(
                'flex items-center gap-3 rounded-lg px-3 py-2.5 text-sm font-medium transition-colors',
                isActive
                  ? 'bg-blue-500/10 text-blue-400'
                  : 'hover:bg-white/5 hover:text-white',
              )}
            >
              <item.icon className="h-5 w-5" />
              {item.name}
            </Link>
          );
        })}
      </nav>
      <div className="border-t border-white/10 p-4">
        <div className="flex items-center gap-3">
          <div className="h-8 w-8 rounded-full bg-gradient-to-br from-blue-500 to-purple-600" />
          <div>
            <p className="text-sm font-medium text-white">Admin User</p>
            <p className="text-xs text-slate-500">admin@leadgen.labs</p>
          </div>
        </div>
      </div>
    </div>
  );
}

