'use client';

import { Bell, Search } from 'lucide-react';

export function AdminHeader() {
  return (
    <header className="flex h-16 items-center justify-between border-b border-white/10 bg-slate-950/50 px-8 backdrop-blur">
      <div className="flex items-center gap-4 text-sm text-slate-400">
        <span className="flex items-center gap-2 rounded-md border border-white/10 bg-slate-900 px-3 py-1.5">
          <Search className="h-4 w-4" />
          <input
            type="text"
            placeholder="Search..."
            className="bg-transparent outline-none placeholder:text-slate-600"
          />
        </span>
      </div>
      <div className="flex items-center gap-4">
        <button className="relative rounded-full p-2 text-slate-400 hover:bg-white/5 hover:text-white">
          <Bell className="h-5 w-5" />
          <span className="absolute right-2 top-2 h-2 w-2 rounded-full bg-rose-500" />
        </button>
      </div>
    </header>
  );
}

