
'use client';

import Link from 'next/link';
import EliteLogo from '@/components/EliteLogo';
import { useState, useEffect } from 'react';

export default function Header() {
    const [isLoggedIn, setIsLoggedIn] = useState(false);

    useEffect(() => {
        // Check if user is logged in (has auth token)
        const token = localStorage.getItem('authToken');
        setIsLoggedIn(!!token);
    }, []);

    return (
        <header className="glass-header w-full">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="flex justify-between items-center h-16">
                    {/* Logo Section */}
                    <div className="flex-shrink-0 flex items-center gap-3">
                        <Link href="/" className="flex items-center gap-2 group">
                            <div className="relative w-8 h-8 rounded-lg shadow-lg group-hover:shadow-cyan-500/20 transition-all duration-300">
                                <EliteLogo className="w-full h-full text-cyan-400" />
                            </div>
                            <span className="font-bold text-xl tracking-tight text-slate-100 group-hover:text-white transition-colors">
                                EventheOdds <span className="text-gradient">AI</span>
                            </span>
                        </Link>
                    </div>

                    {/* Navigation - Only show for logged in users */}
                    {isLoggedIn && (
                        <nav className="hidden md:flex space-x-8">
                            <Link href="/dashboard" className="text-slate-300 hover:text-white px-3 py-2 rounded-md text-sm font-medium transition-colors">
                                Dashboard
                            </Link>
                            <Link href="/strategies" className="text-slate-300 hover:text-white px-3 py-2 rounded-md text-sm font-medium transition-colors">
                                Strategies
                            </Link>
                            <Link href="/backtest" className="text-slate-300 hover:text-white px-3 py-2 rounded-md text-sm font-medium transition-colors">
                                Backtest
                            </Link>
                        </nav>
                    )}

                    {/* Navigation - Always show pricing for non-logged-in users */}
                    {!isLoggedIn && (
                        <nav className="hidden md:flex space-x-8">
                            <Link href="/pricing" className="text-slate-300 hover:text-white px-3 py-2 rounded-md text-sm font-medium transition-colors">
                                Pricing
                            </Link>
                        </nav>
                    )}

                    {/* Action Buttons */}
                    <div className="flex items-center gap-4">
                        {isLoggedIn ? (
                            <>
                                <Link href="/profile" className="text-slate-300 hover:text-white text-sm font-medium transition-colors">
                                    Profile
                                </Link>
                                <button
                                    onClick={async () => {
                                        try {
                                            // Call logout API to clear server-side session/cookie
                                            await fetch('/api/auth/logout', {
                                                method: 'POST',
                                                credentials: 'include',
                                            });
                                        } catch (error) {
                                            console.error('Logout API error:', error);
                                        }
                                        // Clear client-side storage
                                        localStorage.removeItem('authToken');
                                        localStorage.removeItem('user');
                                        setIsLoggedIn(false);
                                        window.location.href = '/';
                                    }}
                                    className="bg-red-600 hover:bg-red-500 text-white px-4 py-2 rounded-lg text-sm font-medium transition-all shadow-lg shadow-red-500/20"
                                >
                                    Sign Out
                                </button>
                            </>
                        ) : (
                            <>
                                <Link href="/login" className="text-slate-300 hover:text-white text-sm font-medium transition-colors">
                                    Sign In
                                </Link>
                                <Link
                                    href="/pricing"
                                    className="bg-blue-600 hover:bg-blue-500 text-white px-4 py-2 rounded-lg text-sm font-medium transition-all shadow-lg shadow-blue-500/20 hover:shadow-blue-500/40"
                                >
                                    Get Started
                                </Link>
                            </>
                        )}
                    </div>
                </div>
            </div>
        </header>
    );
}
