
import React from 'react';

export default function EliteLogo({ className = "w-32 h-32" }: { className?: string }) {
    return (
        <svg
            viewBox="0 0 100 100"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            className={className}
            aria-label="EventheOdds Elite Logo"
        >
            {/* Background Glow (Optional context) */}
            <circle cx="50" cy="50" r="45" fill="url(#glow)" fillOpacity="0.1" />

            {/* The Spine / Y-Axis */}
            <rect x="25" y="20" width="10" height="60" rx="2" fill="#0f172a" />

            {/* Top Bar (Data Line) */}
            <g className="animate-[pulse_4s_infinite]">
                <rect x="35" y="20" width="45" height="10" rx="2" fill="url(#grad1)" />
                <circle cx="85" cy="25" r="3" fill="#06b6d4" />
                <line x1="85" y1="25" x2="30" y2="25" stroke="#06b6d4" strokeWidth="1" strokeOpacity="0.5" />
            </g>

            {/* Middle Bar (Shorter) */}
            <g className="animate-[pulse_4s_infinite_1s]">
                <rect x="35" y="45" width="30" height="10" rx="2" fill="url(#grad2)" />
                <circle cx="70" cy="50" r="3" fill="#3b82f6" />
                <line x1="70" y1="50" x2="30" y2="50" stroke="#3b82f6" strokeWidth="1" strokeOpacity="0.5" />
            </g>

            {/* Bottom Bar */}
            <g className="animate-[pulse_4s_infinite_2s]">
                <rect x="35" y="70" width="45" height="10" rx="2" fill="url(#grad1)" />
                <circle cx="85" cy="75" r="3" fill="#06b6d4" />
                <line x1="85" y1="75" x2="30" y2="75" stroke="#06b6d4" strokeWidth="1" strokeOpacity="0.5" />
            </g>

            {/* Connection Graph Lines (Neural Net feel) */}
            <path d="M85 25 L 70 50 L 85 75" stroke="#22d3ee" strokeWidth="0.5" strokeOpacity="0.3" strokeDasharray="2 2" />

            {/* Definitions */}
            <defs>
                <radialGradient id="glow" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(50 50) rotate(90) scale(45)">
                    <stop stopColor="#06b6d4" />
                    <stop offset="1" stopColor="#06b6d4" stopOpacity="0" />
                </radialGradient>
                <linearGradient id="grad1" x1="35" y1="25" x2="80" y2="25" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#0e7490" />
                    <stop offset="1" stopColor="#22d3ee" />
                </linearGradient>
                <linearGradient id="grad2" x1="35" y1="50" x2="65" y2="50" gradientUnits="userSpaceOnUse">
                    <stop stopColor="#1e3a8a" />
                    <stop offset="1" stopColor="#3b82f6" />
                </linearGradient>
            </defs>
        </svg>
    );
}
