'use client';

import { useEffect, useState } from 'react';
import Link from 'next/link';
import { CheckCircle, ArrowRight, MessageSquare, BarChart3, Zap, Star } from 'lucide-react';

export default function WelcomePage() {
  const [step, setStep] = useState(0);

  useEffect(() => {
    const timer = setTimeout(() => {
      if (step < 3) {
        setStep(step + 1);
      }
    }, 2000);

    return () => clearTimeout(timer);
  }, [step]);

  const steps = [
    "Setting up your account...",
    "Configuring your workspace...",
    "Preparing your AI assistant...",
    "Welcome to EventheOdds.ai!"
  ];

  const features = [
    {
      icon: MessageSquare,
      title: "AI Strategy Chat",
      description: "Talk to our AI assistant to generate and refine sports betting strategies"
    },
    {
      icon: BarChart3,
      title: "Strategy Playground",
      description: "Test strategies across sports leagues with historical data"
    },
    {
      icon: Zap,
      title: "Real-time Backtesting",
      description: "Get instant results with our high-performance engine"
    }
  ];

  return (
    <div className="min-h-screen bg-slate-950 flex items-center justify-center px-4">
      <div className="max-w-2xl w-full text-center">
        {step < 3 ? (
          <div className="space-y-8">
            <div className="flex justify-center">
              <div className="relative">
                <div className="w-24 h-24 bg-gradient-to-br from-blue-500 to-purple-500 rounded-full flex items-center justify-center">
                  <Zap className="h-12 w-12 text-white animate-pulse" />
                </div>
                <div className="absolute -top-2 -right-2 w-8 h-8 bg-green-500 rounded-full flex items-center justify-center">
                  <CheckCircle className="h-5 w-5 text-white" />
                </div>
              </div>
            </div>

            <div>
              <h1 className="text-3xl font-bold text-white mb-4">Welcome to EventheOdds.ai!</h1>
              <p className="text-slate-400 text-lg">{steps[step]}</p>
            </div>

            <div className="flex justify-center space-x-2">
              {[0, 1, 2].map((i) => (
                <div
                  key={i}
                  className={`w-3 h-3 rounded-full transition-colors ${
                    i <= step ? 'bg-blue-500' : 'bg-slate-600'
                  }`}
                />
              ))}
            </div>
          </div>
        ) : (
          <div className="space-y-8">
            <div className="flex justify-center">
              <div className="w-24 h-24 bg-gradient-to-br from-green-500 to-emerald-500 rounded-full flex items-center justify-center">
                <CheckCircle className="h-12 w-12 text-white" />
              </div>
            </div>

            <div>
              <h1 className="text-4xl font-bold text-white mb-4">
                You&apos;re All Set! 🎉
              </h1>
              <p className="text-slate-400 text-lg mb-8">
                Your account is ready and your AI sports betting assistant is ready to help you test strategies on real data.
              </p>
            </div>

            <div className="grid md:grid-cols-3 gap-6 mb-8">
              {features.map((feature, index) => (
                <div key={index} className="bg-slate-900/50 border border-white/10 rounded-xl p-6">
                  <div className="w-12 h-12 bg-blue-500/20 rounded-xl flex items-center justify-center mb-4 mx-auto">
                    <feature.icon className="h-6 w-6 text-blue-400" />
                  </div>
                  <h3 className="text-lg font-semibold text-white mb-2">{feature.title}</h3>
                  <p className="text-slate-400 text-sm">{feature.description}</p>
                </div>
              ))}
            </div>

            <div className="bg-gradient-to-r from-blue-500/10 to-purple-500/10 border border-blue-500/20 rounded-xl p-6 mb-8">
              <div className="flex items-start gap-4">
                <Star className="h-6 w-6 text-yellow-400 mt-1" />
                <div className="text-left">
                  <h3 className="text-lg font-semibold text-white mb-2">Quick Start Guide</h3>
                  <ul className="text-slate-300 space-y-1 text-sm">
                    <li>• Try the AI chat to generate your first strategy</li>
                    <li>• Use the playground to backtest across sports leagues</li>
                    <li>• Save successful strategies to your personal library</li>
                    <li>• Check analytics to track your performance</li>
                  </ul>
                </div>
              </div>
            </div>

            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link
                href="/dashboard"
                className="bg-gradient-to-r from-blue-600 to-blue-500 hover:from-blue-500 hover:to-blue-400 text-white px-8 py-4 rounded-xl font-semibold text-lg transition-all transform hover:scale-105 shadow-xl flex items-center justify-center gap-2"
              >
                Enter Your Dashboard
                <ArrowRight className="h-6 w-6" />
              </Link>

              <Link
                href="/docs/getting-started"
                className="border border-white/20 bg-white/5 hover:bg-white/10 text-white px-8 py-4 rounded-xl font-semibold text-lg transition"
              >
                View Documentation
              </Link>
            </div>

            <p className="text-slate-500 text-sm mt-6">
              Need help? Contact our support team anytime.
            </p>
          </div>
        )}
      </div>
    </div>
  );
}
