import Link from "next/link";
import { ArrowLeft } from "lucide-react";

export default function TermsPage() {
  return (
    <main className="min-h-screen bg-slate-950 text-white">
      <div className="max-w-4xl mx-auto px-6 py-12">
        <Link href="/" className="inline-flex items-center gap-2 text-slate-400 hover:text-white transition-colors mb-8">
          <ArrowLeft className="h-4 w-4" />
          Back to Home
        </Link>

        <div className="space-y-8">
          <div>
            <h1 className="text-4xl font-bold mb-4">Terms of Service</h1>
            <p className="text-slate-400">Last updated: November 23, 2025</p>
          </div>

          <div className="glass-panel p-8 rounded-xl space-y-6">
            <section>
              <h2 className="text-2xl font-semibold mb-4">1. Acceptance of Terms</h2>
              <p className="text-slate-300">
                By accessing and using EventheOdds.ai, you accept and agree to be bound by the terms
                and provision of this agreement.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">2. Use License</h2>
              <p className="text-slate-300 mb-4">
                Permission is granted to temporarily access the materials (information or software)
                on EventheOdds.ai for personal, non-commercial transitory viewing only.
              </p>
              <p className="text-slate-300">
                This license shall automatically terminate if you violate any of these restrictions and may be terminated by EventheOdds.ai at any time.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">3. Service Description</h2>
              <p className="text-slate-300 mb-4">
                EventheOdds.ai provides an AI-powered platform for researching and backtesting sports betting strategies.
                Our services include:
              </p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Conversational AI for strategy generation</li>
                <li>Backtesting across supported sports and leagues</li>
                <li>Performance analytics and optimization</li>
                <li>Educational content and community features</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">4. User Responsibilities</h2>
              <p className="text-slate-300 mb-4">You agree to:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Provide accurate and complete information</li>
                <li>Use the service in compliance with applicable laws</li>
                <li>Not engage in fraudulent or illegal activities</li>
                <li>Respect intellectual property rights</li>
                <li>Maintain the security of your account credentials</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">5. Prohibited Uses</h2>
              <p className="text-slate-300 mb-4">You may not:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Use the service for any unlawful purpose</li>
                <li>Attempt to gain unauthorized access to our systems</li>
                <li>Interfere with or disrupt the service</li>
                <li>Share your account credentials with others</li>
                <li>Reverse engineer or copy our technology</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">6. Subscription and Payment</h2>
              <p className="text-slate-300">
                Subscription fees are billed in advance on a recurring basis. You authorize us to charge
                your payment method for all fees incurred. All fees are non-refundable unless otherwise stated.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">7. Termination</h2>
              <p className="text-slate-300">
                We may terminate or suspend your account immediately, without prior notice or liability,
                for any reason, including breach of these Terms.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">8. Disclaimer</h2>
              <p className="text-slate-300">
                The information on this website is provided on an 'as is' basis. To the fullest extent
                permitted by law, EventheOdds.ai excludes all representations, warranties, conditions and terms
                whether express or implied, statutory or otherwise.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">9. Contact Information</h2>
              <p className="text-slate-300">
                If you have any questions about these Terms, please contact us at{" "}
                <a href="mailto:legal@eventheodds.ai" className="text-blue-400 hover:text-blue-300">
                  legal@eventheodds.ai
                </a>
              </p>
            </section>
          </div>
        </div>
      </div>
    </main>
  );
}