import Link from "next/link";
import { ArrowLeft } from "lucide-react";

export default function PrivacyPage() {
  return (
    <main className="min-h-screen bg-slate-950 text-white">
      <div className="max-w-4xl mx-auto px-6 py-12">
        <Link href="/" className="inline-flex items-center gap-2 text-slate-400 hover:text-white transition-colors mb-8">
          <ArrowLeft className="h-4 w-4" />
          Back to Home
        </Link>

        <div className="space-y-8">
          <div>
            <h1 className="text-4xl font-bold mb-4">Privacy Policy</h1>
            <p className="text-slate-400">Last updated: November 23, 2025</p>
          </div>

          <div className="glass-panel p-8 rounded-xl space-y-6">
            <section>
              <h2 className="text-2xl font-semibold mb-4">1. Information We Collect</h2>
              <p className="text-slate-300 mb-4">
                We collect information you provide directly to us, such as when you create an account,
                use our services, or contact us for support.
              </p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Account information (email, name, subscription details)</li>
                <li>Strategy data and backtesting results</li>
                <li>Usage analytics and performance metrics</li>
                <li>Communication preferences</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">2. How We Use Your Information</h2>
              <p className="text-slate-300 mb-4">We use the information we collect to:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Provide, maintain, and improve our services</li>
                <li>Process transactions and send related information</li>
                <li>Send technical notices and support messages</li>
                <li>Communicate with you about products, services, and promotions</li>
                <li>Monitor and analyze usage patterns</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">3. Information Sharing</h2>
              <p className="text-slate-300">
                We do not sell, trade, or otherwise transfer your personal information to third parties
                without your consent, except as described in this policy. We may share your information
                only in limited circumstances, such as with service providers who help us operate our platform.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">4. Data Security</h2>
              <p className="text-slate-300">
                We implement appropriate technical and organizational measures to protect your personal
                information against unauthorized access, alteration, disclosure, or destruction.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">5. Your Rights</h2>
              <p className="text-slate-300 mb-4">You have the right to:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Access and update your personal information</li>
                <li>Delete your account and associated data</li>
                <li>Opt-out of marketing communications</li>
                <li>Request data portability</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">6. Contact Us</h2>
              <p className="text-slate-300">
                If you have any questions about this Privacy Policy, please contact us at{" "}
                <a href="mailto:privacy@eventheodds.ai" className="text-blue-400 hover:text-blue-300">
                  privacy@eventheodds.ai
                </a>
              </p>
            </section>
          </div>
        </div>
      </div>
    </main>
  );
}