'use client';

'use client';

import Link from "next/link";
import { useState } from "react";
import { Check, Star, Zap, Crown, ArrowRight } from "lucide-react";

export default function PricingPage() {
  const [isAnnual, setIsAnnual] = useState(false);
  return (
    <main className="min-h-screen bg-slate-950 text-white">
      {/* Hero Section */}
      <section className="relative py-20 px-6">
        <div className="max-w-4xl mx-auto text-center">
          <h1 className="text-5xl md:text-6xl font-bold mb-6">
            Choose Your <span className="text-gradient">EventheOdds</span> Plan
          </h1>
          <p className="text-xl text-slate-400 mb-12 max-w-2xl mx-auto">
            Start with our free trial and upgrade as you grow. All plans include access to our AI-powered backtesting platform.
          </p>

          {/* Trial Banner - Primary CTA */}
          <div className="bg-gradient-to-r from-blue-600/20 to-purple-600/20 border border-blue-500/30 rounded-2xl p-8 mb-12">
            <div className="text-center">
              <div className="inline-flex items-center gap-3 mb-4">
                <Star className="h-6 w-6 text-yellow-400" />
                <span className="text-xl font-bold text-white">Start Your Free Trial Today</span>
              </div>
              <p className="text-slate-300 mb-6">Get full access to EventheOdds.ai for 7 days. No commitment required.</p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Link
                  href="/signup?tier=pro"
                  className="px-8 py-4 bg-blue-600 hover:bg-blue-500 text-white rounded-xl font-semibold shadow-lg shadow-blue-500/25 transition-all hover:scale-105"
                >
                  Try Pro - $1 for 7 Days
                </Link>
                <Link
                  href="/signup?tier=elite"
                  className="px-8 py-4 bg-purple-600 hover:bg-purple-500 text-white rounded-xl font-semibold shadow-lg shadow-purple-500/25 transition-all hover:scale-105"
                >
                  Try Elite - $20 for 7 Days
                </Link>
              </div>
            </div>
          </div>

          {/* Billing Toggle */}
          <div className="flex items-center justify-center gap-4 mb-8">
            <span className={`text-sm font-medium ${!isAnnual ? 'text-white' : 'text-slate-400'}`}>Monthly</span>
            <button
              onClick={() => setIsAnnual(!isAnnual)}
              className={`relative inline-flex h-6 w-11 items-center rounded-full transition-colors ${
                isAnnual ? 'bg-blue-600' : 'bg-slate-600'
              }`}
            >
              <span
                className={`inline-block h-4 w-4 transform rounded-full bg-white transition-transform ${
                  isAnnual ? 'translate-x-6' : 'translate-x-1'
                }`}
              />
            </button>
            <div className="flex items-center gap-2">
              <span className={`text-sm font-medium ${isAnnual ? 'text-white' : 'text-slate-400'}`}>Annual</span>
              {isAnnual && (
                <span className="bg-green-500 text-white text-xs px-2 py-1 rounded-full font-semibold">
                  Save 17%
                </span>
              )}
            </div>
          </div>
        </div>
      </section>

      {/* Pricing Cards */}
      <section className="pb-20 px-6">
        <div className="max-w-6xl mx-auto">
          <div className="grid md:grid-cols-2 gap-8 max-w-4xl mx-auto">

            {/* Pro Tier - Most Popular */}
            <div className="glass-panel p-8 rounded-2xl relative">

              <div className="text-center mb-8">
                <div className="flex items-center justify-center gap-2 mb-2">
                  <Zap className="h-6 w-6 text-blue-400" />
                  <h3 className="text-2xl font-bold text-white">Pro</h3>
                </div>
                <div className="text-3xl font-bold text-white mb-1">$1</div>
                <p className="text-slate-400 text-sm">for 7 days, then</p>
                <div className="text-2xl font-bold text-white">
                  {isAnnual ? (
                    <>
                      <span className="line-through text-slate-500 text-lg mr-2">$240</span>
                      $199<span className="text-slate-400 text-lg">/year</span>
                    </>
                  ) : (
                    <>
                      $20<span className="text-slate-400 text-lg">/month</span>
                    </>
                  )}
                </div>
                <p className="text-sm text-slate-500 mt-1">{isAnnual ? 'Billed annually after trial' : 'After 7-day trial'}</p>
                {isAnnual && <p className="text-green-400 text-sm font-semibold mt-1">Save $41/year</p>}
              </div>

              <ul className="space-y-4 mb-8">
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Unlimited AI strategy generations</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Full sports backtesting (NBA, NFL, MLB, NHL, NCAA)</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Advanced analytics & charts</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Walk-forward analysis</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Parameter optimization (limited)</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Priority email support</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Strategy export & sharing</span>
                </li>
              </ul>

              <Link
                href="/signup?tier=pro"
                className="w-full bg-blue-600 hover:bg-blue-500 text-white font-semibold py-4 px-6 rounded-xl transition-all hover:scale-105 text-center block shadow-lg shadow-blue-500/25"
              >
                Start Pro Trial
                <ArrowRight className="inline h-4 w-4 ml-2" />
              </Link>
            </div>

            {/* Elite Tier */}
            <div className="glass-panel p-8 rounded-2xl relative">
              <div className="text-center mb-8">
                <div className="flex items-center justify-center gap-2 mb-2">
                  <Crown className="h-6 w-6 text-purple-400" />
                  <h3 className="text-2xl font-bold text-white">Elite</h3>
                </div>
                <div className="text-3xl font-bold text-white mb-1">$20</div>
                <p className="text-slate-400 text-sm">for 7 days, then</p>
                <div className="text-2xl font-bold text-white">
                  {isAnnual ? (
                    <>
                      <span className="line-through text-slate-500 text-lg mr-2">$2,400</span>
                      $1,999<span className="text-slate-400 text-lg">/year</span>
                    </>
                  ) : (
                    <>
                      $200<span className="text-slate-400 text-lg">/month</span>
                    </>
                  )}
                </div>
                <p className="text-sm text-slate-500 mt-1">{isAnnual ? 'Billed annually after trial' : 'After 7-day trial'}</p>
                {isAnnual && <p className="text-green-400 text-sm font-semibold mt-1">Save $401/year</p>}
              </div>

              <ul className="space-y-4 mb-8">
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Everything in Pro, plus:</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Advanced parameter optimization</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Custom data feeds & APIs</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Real-time market data</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Dedicated account manager</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">Phone & video support</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">White-label solutions</span>
                </li>
                <li className="flex items-center gap-3">
                  <Check className="h-5 w-5 text-green-400 flex-shrink-0" />
                  <span className="text-slate-300">API access for integrations</span>
                </li>
              </ul>

              <Link
                href="/signup?tier=elite"
                className="w-full bg-purple-600 hover:bg-purple-500 text-white font-semibold py-4 px-6 rounded-xl transition-all hover:scale-105 text-center block shadow-lg shadow-purple-500/25"
              >
                Start Elite Trial
                <ArrowRight className="inline h-4 w-4 ml-2" />
              </Link>
            </div>
          </div>

          {/* Enterprise CTA */}
          <div className="text-center mt-16">
            <div className="glass-panel p-8 rounded-2xl max-w-2xl mx-auto">
              <h3 className="text-2xl font-bold text-white mb-4">Need Enterprise Solutions?</h3>
              <p className="text-slate-400 mb-6">
                Custom integrations, dedicated infrastructure, and enterprise-grade security for large organizations.
              </p>
              <Link
                href="/contact?subject=enterprise"
                className="inline-flex items-center gap-2 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-500 hover:to-purple-500 text-white font-semibold py-3 px-8 rounded-xl transition-all hover:scale-105 shadow-lg shadow-blue-500/25"
              >
                Contact Sales
                <ArrowRight className="h-4 w-4" />
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* FAQ Section */}
      <section className="py-20 px-6 bg-slate-900/50">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl font-bold mb-4">Frequently Asked Questions</h2>
            <p className="text-slate-400">Everything you need to know about our plans</p>
          </div>

          <div className="space-y-6">
            <div className="glass-panel p-6 rounded-xl">
              <h3 className="text-lg font-semibold text-white mb-3">Can I change between monthly and annual billing?</h3>
              <p className="text-slate-300">Yes, you can switch between monthly and annual billing at any time from your account settings. Annual savings apply immediately when you upgrade to annual billing.</p>
            </div>

            <div className="glass-panel p-6 rounded-xl">
              <h3 className="text-lg font-semibold text-white mb-3">Can I change plans anytime?</h3>
              <p className="text-slate-300">Yes, you can upgrade or downgrade your plan at any time. Changes take effect immediately, and we'll prorate any billing adjustments.</p>
            </div>

            <div className="glass-panel p-6 rounded-xl">
              <h3 className="text-lg font-semibold text-white mb-3">What payment methods do you accept?</h3>
              <p className="text-slate-300">We accept all major credit cards. Trial payments and monthly subscriptions are processed securely through Stripe.</p>
            </div>

            <div className="glass-panel p-6 rounded-xl">
              <h3 className="text-lg font-semibold text-white mb-3">How do the trials work?</h3>
              <p className="text-slate-300">Pro: Pay $1 to start your 7-day trial with full Pro features. Elite: Pay $20 to start your 7-day trial with full Elite features. After 7 days, you'll be automatically billed $20/month for Pro or $200/month for Elite. Cancel anytime before the trial ends and you won't be charged further.</p>
            </div>

            <div className="glass-panel p-6 rounded-xl">
              <h3 className="text-lg font-semibold text-white mb-3">Can I cancel anytime?</h3>
              <p className="text-slate-300">Yes, you can cancel your subscription at any time. You'll retain access to paid features until the end of your billing period.</p>
            </div>

            <div className="glass-panel p-6 rounded-xl">
              <h3 className="text-lg font-semibold text-white mb-3">Do you offer annual discounts?</h3>
              <p className="text-slate-300">Yes! Annual plans save you 17% compared to monthly billing. Pro annual: $199/year (save $41), Elite annual: $1,999/year (save $401). All annual plans include the same 7-day trial.</p>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 px-6">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-4xl font-bold mb-6">Ready to Start Backtesting?</h2>
          <p className="text-xl text-slate-400 mb-8">
            Join bettors who trust EventheOdds.ai for strategy development and backtesting.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link
              href="/signup?plan=pro"
              className="px-8 py-4 bg-blue-600 hover:bg-blue-500 text-white rounded-xl font-semibold shadow-lg shadow-blue-500/25 transition-all hover:scale-105"
            >
              Start Free Trial
            </Link>
            <Link
              href="/demo"
              className="px-8 py-4 glass-panel hover:bg-white/5 text-white rounded-xl font-semibold transition-all hover:scale-105"
            >
              View Demo
            </Link>
          </div>
        </div>
      </section>
    </main>
  );
}