
import Image from "next/image";
import Link from "next/link";
import { Server, Cpu, BarChart3, ShieldCheck, Lock, Activity, CheckCircle2, XCircle, Database, Zap, Globe } from "lucide-react";
import EliteLogo from "@/components/EliteLogo";

export default function Home() {
  return (
    <main className="min-h-screen bg-black text-slate-300 selection:bg-cyan-500/30 selection:text-cyan-200 font-sans">

      {/* Background Ambience */}
      <div className="fixed inset-0 z-0 pointer-events-none">
        <Image
          src="/background_elite.png"
          alt="Sports Analytics Background"
          fill
          priority
          quality={90}
          className="object-cover opacity-40"
        />
        <div className="absolute inset-0 bg-gradient-to-b from-black/90 via-black/70 to-black/50" />
        <div className="absolute inset-0 bg-[url('/grid.svg')] opacity-[0.03]" />
      </div>

      <div className="relative z-10 max-w-6xl mx-auto px-6 py-12 md:py-24 space-y-32">

        {/* HERO SECTION */}
        <section className="relative text-center space-y-8 py-16">

          <div className="flex justify-center mb-10">
            <div className="relative w-32 h-32 md:w-40 md:h-40">
              <div className="absolute inset-0 bg-cyan-500/10 blur-[60px] rounded-full" />
              <EliteLogo className="relative z-10 w-full h-full drop-shadow-[0_0_20px_rgba(6,182,212,0.3)]" />
            </div>
          </div>

          <h1 className="text-5xl md:text-7xl lg:text-8xl font-black text-white tracking-tighter leading-[1.1] mb-6">
            Stop Guessing. <br className="hidden md:block" />
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-cyan-400 via-white to-cyan-400">
              Start Calculating.
            </span>
          </h1>

          <p className="text-xl md:text-2xl text-slate-400 max-w-3xl mx-auto font-light leading-relaxed">
            Most betting is entertainment. This is not. <br />
            <span className="text-slate-500 text-lg block mt-4">
              EventheOdds.ai is a decision engine for those who view sports betting as a probability problem to be solved, not a game to be played. Turn your intuition into a data-driven, backtested system.
            </span>
          </p>

          {/* Hero CTA - Start Pro Trial */}
          <Link href="/signup?tier=pro" className="group relative block w-full max-w-2xl mx-auto mt-16 overflow-hidden rounded-2xl border border-white/10 bg-slate-900/50 backdrop-blur-xl shadow-2xl shadow-cyan-900/20 hover:border-cyan-500/50 hover:shadow-cyan-500/20 transition-all duration-300 transform hover:scale-[1.02]">
            <div className="absolute inset-0 bg-gradient-to-r from-cyan-500/10 to-purple-500/10 opacity-50 group-hover:opacity-100 transition-opacity" />
            <div className="relative z-10 p-8 md:p-10 flex flex-col items-center gap-4">
              <div className="w-16 h-16 rounded-full bg-cyan-900/30 flex items-center justify-center border border-cyan-500/30 group-hover:bg-cyan-500/20 transition-colors mb-2">
                <Activity className="w-8 h-8 text-cyan-400" />
              </div>
              <div className="space-y-1">
                <h2 className="text-2xl md:text-3xl font-bold text-white tracking-tight">START YOUR PRO TRIAL</h2>
                <p className="text-cyan-400 font-bold uppercase tracking-widest">$1 for 7 Days</p>
              </div>
              <div className="flex items-center gap-3 text-slate-400 text-xs font-medium tracking-wide pt-2">
                OR ELITE TRIAL - $20 FOR 7 DAYS
              </div>
            </div>
          </Link>
        </section>


        {/* PROVEN INFRASTRUCTURE */}
        <section className="space-y-12">
          <div className="text-center space-y-4">
            <h3 className="text-sm font-bold text-slate-500 uppercase tracking-[0.2em]">Proven Infrastructure</h3>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div className="bg-slate-900/40 border border-white/5 p-6 rounded-xl flex flex-col items-center text-center backdrop-blur-sm hover:border-cyan-500/30 transition-colors">
              <Database className="w-8 h-8 text-cyan-500 mb-4" />
              <div className="text-3xl font-bold text-white mb-1">50K+</div>
              <div className="text-sm text-slate-500 uppercase tracking-widest">Strategies Tested</div>
            </div>
            <div className="bg-slate-900/40 border border-white/5 p-6 rounded-xl flex flex-col items-center text-center backdrop-blur-sm hover:border-green-500/30 transition-colors">
              <BarChart3 className="w-8 h-8 text-green-500 mb-4" />
              <div className="text-3xl font-bold text-white mb-1">12%</div>
              <div className="text-sm text-slate-500 uppercase tracking-widest">Avg. ROI Boost*</div>
            </div>
            <div className="bg-slate-900/40 border border-white/5 p-6 rounded-xl flex flex-col items-center text-center backdrop-blur-sm hover:border-purple-500/30 transition-colors">
              <Zap className="w-8 h-8 text-purple-500 mb-4" />
              <div className="text-3xl font-bold text-white mb-1">99.9%</div>
              <div className="text-sm text-slate-500 uppercase tracking-widest">Platform Uptime</div>
            </div>
          </div>

          <div className="text-center pt-8 border-t border-white/5">
            <p className="text-slate-400 mb-4 font-medium">All Major Leagues & Sports</p>
            <div className="flex flex-wrap justify-center gap-4 text-slate-600 font-bold text-sm uppercase tracking-wider">
              <span>NBA</span> <span className="text-slate-800">•</span>
              <span>NFL</span> <span className="text-slate-800">•</span>
              <span>MLB</span> <span className="text-slate-800">•</span>
              <span>NHL</span> <span className="text-slate-800">•</span>
              <span>Soccer</span> <span className="text-slate-800">•</span>
              <span>UFC</span> <span className="text-slate-800">•</span>
              <span>Tennis</span> <span className="text-slate-800">•</span>
              <span>Golf</span>
            </div>
            <p className="text-[10px] text-slate-600 mt-8 italic">*Hypothetical results based on backtesting.</p>
          </div>
        </section>


        {/* THE HOUSE SECTION */}
        <section className="grid md:grid-cols-2 gap-12 items-center">
          <div className="space-y-6">
            <h2 className="text-3xl md:text-4xl font-bold text-white leading-tight">
              The House Doesn’t Feel. <br />
              <span className="text-slate-500">It Calculates.</span>
            </h2>
            <div className="space-y-4 text-lg text-slate-400 border-l-2 border-cyan-500/30 pl-6">
              <p>Every line you see has already passed through historical models, probability distributions, and risk margins. The house has its edge before you ever place a bet.</p>
              <p className="text-white font-medium">We give you access to that layer.</p>
            </div>
            <p className="text-slate-500 text-sm pt-4 leading-relaxed">
              EventheOdds.ai is the conversational AI platform that lets you build, backtest, and optimize betting strategies across major sports. Chat with AI to model outcomes, test assumptions, and remove emotion from the process. You don't get told what to bet; you get shown what the data says.
            </p>
          </div>

          {/* Graphical Representation */}
          <div className="grid grid-cols-2 gap-4">
            <div className="bg-slate-900/40 p-6 rounded-xl border border-white/5 backdrop-blur-md hover:border-cyan-500/30 transition-all duration-300 group">
              <Server className="w-8 h-8 text-cyan-400 mb-4 group-hover:scale-110 transition-transform" />
              <h3 className="text-white font-bold mb-1">Models</h3>
              <p className="text-xs text-slate-500">Historical data layer access.</p>
            </div>
            <div className="bg-slate-900/40 p-6 rounded-xl border border-white/5 backdrop-blur-md hover:border-purple-500/30 transition-all duration-300 group">
              <Cpu className="w-8 h-8 text-purple-400 mb-4 group-hover:scale-110 transition-transform" />
              <h3 className="text-white font-bold mb-1">Distributions</h3>
              <p className="text-xs text-slate-500">Probability & Variance analysis.</p>
            </div>
            <div className="bg-slate-900/40 p-6 rounded-xl border border-white/5 backdrop-blur-md hover:border-green-500/30 transition-all duration-300 group">
              <BarChart3 className="w-8 h-8 text-green-400 mb-4 group-hover:scale-110 transition-transform" />
              <h3 className="text-white font-bold mb-1">Optimization</h3>
              <p className="text-xs text-slate-500">Strategy refinement engine.</p>
            </div>
            <div className="bg-slate-900/40 p-6 rounded-xl border border-white/5 backdrop-blur-md hover:border-red-500/30 transition-all duration-300 group">
              <ShieldCheck className="w-8 h-8 text-red-400 mb-4 group-hover:scale-110 transition-transform" />
              <h3 className="text-white font-bold mb-1">Risk Logic</h3>
              <p className="text-xs text-slate-500">Emotion removal system.</p>
            </div>
          </div>
        </section>


        {/* THIS IS NOT "LOCK OF THE DAY" / WHY IT WORKS */}
        <section className="space-y-12">
          <div className="grid md:grid-cols-2 gap-12">
            {/* NOT */}
            <div className="space-y-6">
              <div className="flex items-center gap-3 mb-2">
                <Lock className="w-6 h-6 text-red-400" />
                <h3 className="text-xl font-bold text-white">This Is Not "Lock of the Day."</h3>
              </div>
              <h2 className="text-3xl font-bold text-white">This is Control.</h2>
              <p className="text-slate-400 leading-relaxed">
                This is for those who think in probabilities, value discipline over action, and are comfortable saying "no bet." It is intentionally built for the strategic mind.
              </p>
            </div>

            {/* WHY IT WORKS */}
            <div className="bg-slate-900/20 border border-white/5 rounded-2xl p-8 backdrop-blur-sm">
              <h3 className="text-xl font-bold text-white mb-6">Why It Works</h3>
              <ul className="space-y-6">
                <li className="flex gap-4">
                  <Cpu className="w-6 h-6 text-cyan-500 flex-shrink-0" />
                  <div>
                    <h4 className="font-bold text-white">Industry-Leading AI</h4>
                    <p className="text-sm text-slate-400">Trained on thousands of strategies and historical data.</p>
                  </div>
                </li>
                <li className="flex gap-4">
                  <ShieldCheck className="w-6 h-6 text-green-500 flex-shrink-0" />
                  <div>
                    <h4 className="font-bold text-white">Secure & Private</h4>
                    <p className="text-sm text-slate-400">Bank-level security. Your strategies are yours.</p>
                  </div>
                </li>
                <li className="flex gap-4">
                  <Globe className="w-6 h-6 text-purple-500 flex-shrink-0" />
                  <div>
                    <h4 className="font-bold text-white">Community Driven</h4>
                    <p className="text-sm text-slate-400">Learn from and share with other sharp bettors.</p>
                  </div>
                </li>
              </ul>
            </div>
          </div>
        </section>


        {/* PRICING */}
        <section className="space-y-12 max-w-5xl mx-auto">
          <div className="text-center space-y-4">
            <h2 className="text-3xl font-bold text-white">Simple, Transparent Pricing</h2>
            <p className="text-slate-500">Choose the tier that matches your level of engagement.</p>
          </div>

          <div className="grid md:grid-cols-2 gap-8 items-stretch">
            {/* PRO */}
            <div className="group relative bg-gradient-to-br from-slate-900 to-black border border-white/10 p-8 rounded-2xl hover:border-cyan-500/50 transition-all duration-300 overflow-hidden">
              <div className="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                <Activity className="w-32 h-32 text-cyan-500" />
              </div>

              <div className="relative z-10 space-y-6">
                <div className="inline-block px-3 py-1 bg-cyan-900/30 text-cyan-400 text-xs font-bold uppercase tracking-widest rounded-full border border-cyan-500/20">
                  Pro Trial
                </div>
                <div>
                  <div className="text-4xl font-bold text-white">$1<span className="text-lg text-slate-500"> for 7 days</span></div>
                  <div className="text-slate-400 text-sm mt-1">then $20/month</div>
                </div>
                <p className="text-slate-400 text-sm">Perfect for individual bettors who want data-driven strategy validation.</p>
                <ul className="space-y-3 text-sm text-slate-300 pt-4 border-t border-white/5">
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-cyan-500" /> Unlimited Strategy Backtesting</li>
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-cyan-500" /> All Sports Markets & Leagues</li>
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-cyan-500" /> Advanced Analytics Dashboard</li>
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-cyan-500" /> Priority Email Support</li>
                </ul>
                <div className="pt-4 space-y-3">
                  <Link href="/signup?tier=pro&trial=true" className="block w-full py-4 text-center bg-white text-black font-bold rounded-lg hover:bg-cyan-50 hover:scale-[1.02] transition-all">
                    Start 7-Day Trial – $1
                  </Link>
                  <Link href="/signup?tier=pro" className="block w-full py-3 text-center border border-white/20 text-slate-300 font-medium rounded-lg hover:border-cyan-500/50 hover:text-white transition-all text-sm">
                    Subscribe Now – $20/month
                  </Link>
                </div>
              </div>
            </div>

            {/* ELITE */}
            <div className="group relative bg-gradient-to-br from-amber-950/20 to-black border border-amber-500/20 p-8 rounded-2xl hover:border-amber-500/50 transition-all duration-300">
              <div className="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                <ShieldCheck className="w-32 h-32 text-amber-500" />
              </div>
              <div className="absolute top-4 left-4">
                <span className="px-2 py-1 bg-amber-500/20 text-amber-400 text-[10px] font-bold uppercase rounded-full border border-amber-500/30">10x Power</span>
              </div>

              <div className="relative z-10 space-y-6 pt-6">
                <div className="inline-block px-3 py-1 bg-amber-900/20 text-amber-500 text-xs font-bold uppercase tracking-widest rounded-full border border-amber-500/20">
                  Elite Trial
                </div>
                <div>
                  <div className="text-4xl font-bold text-white">$20<span className="text-lg text-slate-500"> for 7 days</span></div>
                  <div className="text-slate-500 text-sm mt-1">then $200/month</div>
                </div>
                <p className="text-slate-400 text-sm">For pros & funds needing live data, genetic optimization, and dedicated support.</p>
                <ul className="space-y-3 text-sm text-slate-300 pt-4 border-t border-white/5">
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-amber-500" /> Everything in Pro +</li>
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-amber-500" /> <strong className="text-white">Real-Time Data Feeds</strong></li>
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-amber-500" /> <strong className="text-white">Genetic Algorithm Optimization</strong></li>
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-amber-500" /> <strong className="text-white">Live Line Movement Tracking</strong></li>
                  <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-amber-500" /> Dedicated Account Manager</li>
                </ul>
                <div className="pt-4 space-y-3">
                  <Link href="/signup?tier=elite&trial=true" className="block w-full py-4 text-center bg-gradient-to-r from-amber-600 to-amber-500 text-white font-bold rounded-lg hover:from-amber-500 hover:to-amber-400 transition-all">
                    Start 7-Day Trial – $20
                  </Link>
                  <Link href="/signup?tier=elite" className="block w-full py-3 text-center border border-amber-500/30 text-amber-400 font-medium rounded-lg hover:bg-amber-500/10 hover:border-amber-500 transition-all text-sm">
                    Subscribe Now – $200/month
                  </Link>
                </div>
              </div>
            </div>
          </div>

          <p className="text-center text-slate-500 text-sm max-w-lg mx-auto">
            Cancel anytime. No commitment.
          </p>
        </section>


        {/* API FOR SCALE */}
        <section className="relative">
          <div className="bg-gradient-to-br from-slate-900/60 to-black/80 border border-violet-500/10 rounded-2xl p-8 md:p-10">
            <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-6">
              <div className="space-y-3">
                <div className="inline-flex items-center gap-2 px-3 py-1 bg-violet-900/30 rounded-full border border-violet-500/20">
                  <Zap className="w-3 h-3 text-violet-400" />
                  <span className="text-violet-300 text-xs font-medium uppercase tracking-wider">API</span>
                </div>
                <h3 className="text-2xl md:text-3xl font-bold text-white">Build at Scale with Our API</h3>
                <p className="text-slate-400 text-sm max-w-xl">
                  Automate your workflows, integrate with external tools, and build custom applications.
                  API tokens available as an add-on during checkout.
                </p>
              </div>
              <div className="flex flex-col sm:flex-row gap-3 md:flex-shrink-0">
                <Link
                  href="/help#api"
                  className="inline-flex items-center justify-center gap-2 px-6 py-3 bg-violet-600/80 hover:bg-violet-500 text-white font-semibold rounded-lg transition-all"
                >
                  <Database className="w-4 h-4" />
                  Explore API Docs
                </Link>
                <Link
                  href="/contact?topic=enterprise"
                  className="inline-flex items-center justify-center gap-2 px-6 py-3 border border-violet-500/30 text-violet-300 hover:bg-violet-500/10 font-medium rounded-lg transition-all"
                >
                  Enterprise Sales
                </Link>
              </div>
            </div>
          </div>
        </section>


        {/* CLOSING GATES */}
        <section className="text-center space-y-16 py-16 border-t border-white/5">

          {/* Disclosure */}
          <div className="max-w-3xl mx-auto space-y-6">
            <h3 className="text-lg font-bold text-white uppercase tracking-widest">A Final, Important Disclosure</h3>
            <p className="text-slate-400 leading-relaxed">
              We do not guarantee profits or provide betting advice. We expose risk, variance, and opportunity through data. What you do with that information is your responsibility.
            </p>
            <div className="bg-slate-900/50 p-6 rounded-xl border border-white/5">
              <p className="text-slate-300 font-medium">This platform is priced and designed for a specific group:</p>
              <p className="text-slate-500 mt-2 text-sm">
                People who understand that most losses come from bad decisions made under pressure, not bad luck. People who know what restraint and calculation are worth.
              </p>
            </div>
          </div>

          {/* Final CTA Gates */}
          <div className="max-w-md mx-auto space-y-8 pt-8">
            <h2 className="text-3xl text-white font-bold">Your Access Awaits</h2>
            <p className="text-slate-400 leading-relaxed">
              If you’ve read this far, you likely don’t need to be sold. You understand the value of replacing emotion with information.
            </p>
            <p className="text-cyan-400 font-medium pb-4">
              This is your gateway. The next decision is calculated.
            </p>

            <Link href="/signup?tier=pro" className="group block w-full bg-white text-black font-bold py-4 rounded-lg hover:bg-cyan-50 hover:scale-[1.02] transition-all shadow-lg shadow-cyan-500/20">
              Start Your Pro Trial - $1 for 7 Days
              <span className="block text-xs font-normal text-slate-600 mt-1">(Full access. No limitations.)</span>
            </Link>
          </div>

          <div className="pt-24 hover:opacity-100 transition-opacity duration-500">
            <EliteLogo className="w-16 h-16 mx-auto drop-shadow-[0_0_15px_rgba(6,182,212,0.5)] text-cyan-500" />
            <p className="text-[10px] text-slate-500 mt-4 uppercase tracking-widest">EventheOdds.ai • Est. 2025</p>
          </div>
        </section>

        {/* FOOTER */}
        <footer className="border-t border-white/5 py-12 md:py-24 space-y-12">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 md:gap-12">
            <div className="col-span-2 md:col-span-1 space-y-4">
              <div className="flex items-center gap-3">
                <EliteLogo className="w-10 h-10 text-cyan-400 drop-shadow-[0_0_8px_rgba(6,182,212,0.6)]" />
                <span className="font-bold text-white tracking-widest uppercase text-base">EventheOdds</span>
              </div>
              <p className="text-slate-500 text-sm leading-relaxed">
                The decision engine for calculated sports betting. Remove emotion. Execute with data.
              </p>
            </div>

            <div className="space-y-4">
              <h4 className="text-white font-bold uppercase tracking-widest text-xs">Platform</h4>
              <ul className="space-y-2 text-sm text-slate-400">
                <li><Link href="/community" className="hover:text-cyan-400 transition-colors">Community</Link></li>
                <li><Link href="/help" className="hover:text-cyan-400 transition-colors">Help Center</Link></li>
                <li><Link href="/support" className="hover:text-cyan-400 transition-colors">Support</Link></li>
              </ul>
            </div>

            <div className="space-y-4">
              <h4 className="text-white font-bold uppercase tracking-widest text-xs">Legal</h4>
              <ul className="space-y-2 text-sm text-slate-400">
                <li><Link href="/terms" className="hover:text-cyan-400 transition-colors">Terms of Service</Link></li>
                <li><Link href="/privacy" className="hover:text-cyan-400 transition-colors">Privacy Policy</Link></li>
                <li><Link href="/cookies" className="hover:text-cyan-400 transition-colors">Cookie Policy</Link></li>
                <li><Link href="/legal" className="hover:text-cyan-400 transition-colors">Legal Hub</Link></li>
              </ul>
            </div>

            <div className="space-y-4">
              <h4 className="text-white font-bold uppercase tracking-widest text-xs">Risk</h4>
              <ul className="space-y-2 text-sm text-slate-400">
                <li><Link href="/disclaimer" className="hover:text-cyan-400 transition-colors">Disclaimer</Link></li>
                <li><a href="https://www.ncpgambling.org/" target="_blank" rel="noopener noreferrer" className="hover:text-cyan-400 transition-colors">Responsible Gambling</a></li>
              </ul>
            </div>
          </div>

          <div className="pt-8 border-t border-white/5 flex flex-col md:flex-row justify-between items-center gap-4 text-xs text-slate-600">
            <p>&copy; 2025 EventheOdds.ai. All rights reserved.</p>
            <div className="flex gap-6">
              <span>System Status: <span className="text-green-500">Operational</span></span>
              <span>Sitemap</span>
            </div>
          </div>
        </footer>

      </div>
    </main>
  );
}
