
import Link from "next/link";
import { ArrowLeft, Scale, Shield, FileText, Cookie } from "lucide-react";

export default function LegalHub() {
    return (
        <main className="min-h-screen bg-black text-slate-300 font-sans p-6 md:p-12">
            <div className="max-w-4xl mx-auto space-y-12">
                <Link href="/" className="inline-flex items-center gap-2 text-slate-500 hover:text-cyan-400 transition-colors">
                    <ArrowLeft className="w-4 h-4" /> Back to Home
                </Link>

                <div className="space-y-4">
                    <h1 className="text-4xl md:text-5xl font-black text-white tracking-tight">Legal Hub</h1>
                    <p className="text-xl text-slate-400">Transparency and compliance protocols.</p>
                </div>

                <div className="grid md:grid-cols-2 gap-6">
                    <Link href="/terms" className="group p-8 rounded-2xl bg-slate-900/40 border border-white/5 hover:border-cyan-500/30 transition-all">
                        <Scale className="w-8 h-8 text-cyan-500 mb-4" />
                        <h2 className="text-2xl font-bold text-white mb-2 group-hover:text-cyan-400 transition-colors">Terms of Service</h2>
                        <p className="text-slate-500">Agreement governing your use of the EventheOdds.ai platform.</p>
                    </Link>

                    <Link href="/privacy" className="group p-8 rounded-2xl bg-slate-900/40 border border-white/5 hover:border-purple-500/30 transition-all">
                        <Shield className="w-8 h-8 text-purple-500 mb-4" />
                        <h2 className="text-2xl font-bold text-white mb-2 group-hover:text-purple-400 transition-colors">Privacy Policy</h2>
                        <p className="text-slate-500">How we collect, use, and protect your personal data.</p>
                    </Link>

                    <Link href="/disclaimer" className="group p-8 rounded-2xl bg-slate-900/40 border border-white/5 hover:border-amber-500/30 transition-all">
                        <FileText className="w-8 h-8 text-amber-500 mb-4" />
                        <h2 className="text-2xl font-bold text-white mb-2 group-hover:text-amber-400 transition-colors">Disclaimer</h2>
                        <p className="text-slate-500">Risk disclosures regarding sports betting and financial outcomes.</p>
                    </Link>

                    <Link href="/cookies" className="group p-8 rounded-2xl bg-slate-900/40 border border-white/5 hover:border-pink-500/30 transition-all">
                        <Cookie className="w-8 h-8 text-pink-500 mb-4" />
                        <h2 className="text-2xl font-bold text-white mb-2 group-hover:text-pink-400 transition-colors">Cookie Policy</h2>
                        <p className="text-slate-500">Information about cookies and tracking technologies.</p>
                    </Link>
                </div>

                <div className="pt-12 border-t border-white/5 text-center text-slate-500 text-sm">
                    &copy; {new Date().getFullYear()} EventheOdds.ai. All rights reserved.
                </div>
            </div>
        </main>
    );
}
