import type { Metadata } from "next";
import "./globals.css";
import ErrorBoundary from "@/components/ErrorBoundary";
import Header from "@/components/Header";

export const metadata: Metadata = {
  title: "EventheOdds.ai - Premier Sports Betting Strategy Platform",
  description: "AI-powered sports betting strategies. Backtest your betting systems with conversational AI. Turn your intuition into profitable, data-backed strategies.",
  keywords: "sports betting, backtesting, strategy, AI, odds, NBA, NFL, MLB, quantitative analysis, algorithmic betting",
  authors: [{ name: "EventheOdds AI Team" }],
  creator: "EventheOdds AI",
  publisher: "EventheOdds AI",
  formatDetection: {
    email: false,
    address: false,
    telephone: false,
  },
  metadataBase: new URL(process.env.NEXT_PUBLIC_BASE_URL || 'http://localhost:3000'),
  openGraph: {
    title: "EventheOdds.ai - Premier Sports Betting Strategy Platform",
    description: "AI-powered sports betting strategies. Backtest your betting systems with conversational AI.",
    url: "/",
    siteName: "EventheOdds.ai",
    images: [
      {
        url: "/og-image.jpg",
        width: 1200,
        height: 630,
        alt: "EventheOdds AI Platform",
      },
    ],
    locale: "en_US",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "EventheOdds.ai - AI Sports Betting Strategies",
    description: "Create and test sports betting strategies using conversational AI.",
    images: ["/og-image.jpg"],
    creator: "@eventheoddsai",
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      "max-video-preview": -1,
      "max-image-preview": "large",
      "max-snippet": -1,
    },
  },
  verification: {
    google: process.env.GOOGLE_SITE_VERIFICATION,
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" suppressHydrationWarning>
      {/* Use Tailwind/system fonts to avoid network fetch during build */}
      <body className="font-sans antialiased" suppressHydrationWarning>
        <ErrorBoundary>
          <Header />
          <main className="min-h-[calc(100vh-4rem)]">
            {children}
          </main>
        </ErrorBoundary>
      </body>
    </html>
  );
}
