import Link from "next/link";
import { ArrowLeft, AlertTriangle } from "lucide-react";

export default function DisclaimerPage() {
  return (
    <main className="min-h-screen bg-slate-950 text-white">
      <div className="max-w-4xl mx-auto px-6 py-12">
        <Link href="/" className="inline-flex items-center gap-2 text-slate-400 hover:text-white transition-colors mb-8">
          <ArrowLeft className="h-4 w-4" />
          Back to Home
        </Link>

        <div className="space-y-8">
          <div className="text-center">
            <div className="inline-flex items-center gap-3 mb-4">
              <AlertTriangle className="h-8 w-8 text-yellow-400" />
              <h1 className="text-4xl font-bold">Important Disclaimer</h1>
            </div>
            <p className="text-slate-400">Please read carefully before using our platform</p>
          </div>

          <div className="glass-panel p-8 rounded-xl space-y-6">
            <section className="border-l-4 border-yellow-400 pl-6">
              <h2 className="text-2xl font-semibold mb-4 text-yellow-400">⚠️ Risk Warning</h2>
              <p className="text-slate-300 mb-4">
                <strong>Sports betting involves substantial risk of loss and is not suitable for everyone.</strong>
                Past performance does not guarantee future results. No representation is made that any user will or
                is likely to achieve results similar to those shown in backtesting results.
              </p>
              <p className="text-slate-300">
                You should carefully consider whether sports betting is suitable for you in light of your financial condition.
                You may lose your entire stake.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Hypothetical Performance</h2>
              <div className="bg-red-500/10 border border-red-500/20 rounded-lg p-4 mb-4">
                <p className="text-slate-300">
                  <strong>All backtesting results displayed on this platform are hypothetical.</strong> They are based on historical
                  data and do not represent actual betting outcomes. Hypothetical performance results have many inherent
                  limitations, some of which are described below.
                </p>
              </div>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>No hypothetical backtest can completely account for real-world betting constraints (limits, timing, line movement)</li>
                <li>The ability to withstand losses or adhere to a betting plan in spite of losses are material points</li>
                <li>Backtested results are achieved with the benefit of hindsight</li>
                <li>Vig/juice, availability, and market frictions are not always reflected</li>
                <li>Rules, schedules, and market conditions may have changed since the historical data was recorded</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">No Betting Advice</h2>
              <p className="text-slate-300 mb-4">
                <strong>This platform does not provide gambling or betting advice.</strong> The content on this website
                is provided for educational and informational purposes only. It is not intended to be and does not constitute
                betting advice or any other professional advice.
              </p>
              <p className="text-slate-300">
                You are solely responsible for your betting decisions and for complying with applicable laws and regulations.
                Always bet responsibly.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Sports Betting Risks</h2>
              <p className="text-slate-300 mb-4">Sports betting involves additional risks:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Gambling addiction and problem gambling</li>
                <li>Results can be influenced by injuries, weather, and other unpredictable factors</li>
                <li>House edge and bookmaker margins</li>
                <li>Legal restrictions in some jurisdictions</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Technical Limitations</h2>
              <p className="text-slate-300 mb-4">Our platform has certain technical limitations:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>AI-generated strategies may contain errors or biases</li>
                <li>Backtesting may not account for all real-world market conditions</li>
                <li>Data quality and availability limitations</li>
                <li>System outages and technical issues may occur</li>
              </ul>
            </section>

            <section className="border-t border-white/10 pt-6">
              <h2 className="text-2xl font-semibold mb-4">Acknowledgment</h2>
              <div className="bg-blue-500/10 border border-blue-500/20 rounded-lg p-4">
                <p className="text-slate-300 mb-4">
                  <strong>By using EventheOdds.ai, you acknowledge that:</strong>
                </p>
                <ul className="list-disc list-inside text-slate-300 space-y-2">
                  <li>You understand the risks involved in sports betting</li>
                  <li>You are solely responsible for your betting decisions</li>
                  <li>You will not hold EventheOdds.ai liable for any losses</li>
                  <li>You have read and understood this disclaimer</li>
                </ul>
              </div>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Contact Information</h2>
              <p className="text-slate-300">
                If you have questions about this disclaimer or need assistance, please contact us at{" "}
                <a href="mailto:support@eventheodds.ai" className="text-blue-400 hover:text-blue-300">
                  support@eventheodds.ai
                </a>
              </p>
            </section>
          </div>
        </div>
      </div>
    </main>
  );
}