import Link from 'next/link';
import { ArrowLeft, Play, MessageSquare, BarChart3, Brain, Download } from 'lucide-react';

export default function DemoPage() {
  return (
    <div className="min-h-screen bg-slate-950 text-white">
      {/* Navigation */}
      <nav className="border-b border-white/10 bg-slate-950/50 backdrop-blur">
        <div className="mx-auto max-w-7xl px-6 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-8">
              <Link href="/" className="text-2xl font-bold text-white">
                EventheOdds<span className="text-blue-500">AI</span>
              </Link>
              <Link href="/" className="text-slate-300 hover:text-white transition flex items-center gap-2">
                <ArrowLeft className="h-4 w-4" />
                Back to Home
              </Link>
            </div>
          </div>
        </div>
      </nav>

      {/* Hero */}
      <section className="relative overflow-hidden bg-gradient-to-br from-slate-950 via-slate-900 to-blue-950">
        <div
          className="absolute inset-0 opacity-40"
          style={{
            backgroundImage:
              `url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%239C92AC' fill-opacity='0.05'%3E%3Ccircle cx='30' cy='30' r='2'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E")`,
          }}
        />

        <div className="relative mx-auto max-w-7xl px-6 py-24">
          <div className="text-center space-y-8">
            <div className="inline-flex items-center px-4 py-2 bg-green-500/10 border border-green-500/20 rounded-full text-green-400 text-sm font-medium">
              Live preview — real sports betting backtests
            </div>

            <h1 className="text-5xl md:text-7xl font-bold leading-tight">
              Turn questions into{' '}
              <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-green-400">
                backtested strategies
              </span>
            </h1>

            <p className="text-xl md:text-2xl text-slate-300 max-w-4xl mx-auto leading-relaxed">
              Ask in plain English. Get a real backtest on real data, plus charts and downloadable reports.
            </p>

            <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
              <Link
                href="/signup?trial=true"
                className="group flex items-center gap-3 bg-gradient-to-r from-blue-600 to-blue-500 hover:from-blue-500 hover:to-blue-400 text-white px-8 py-4 rounded-xl font-semibold text-lg transition-all transform hover:scale-105 shadow-xl"
              >
                <Play className="h-6 w-6" />
                Start Trial
              </Link>

              <div className="flex items-center gap-2 text-slate-400">
                <MessageSquare className="h-5 w-5" />
                Run a real backtest after signup
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* What you get */}
      <section className="py-24 bg-slate-950">
        <div className="mx-auto max-w-7xl px-6">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-6">What you’ll get</h2>
            <p className="text-xl text-slate-300 max-w-3xl mx-auto">
              A complete, end-to-end flow — strategy → backtest → chart → downloads.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div className="bg-gradient-to-br from-slate-900/50 to-slate-800/30 border border-white/10 rounded-2xl p-8">
              <div className="w-12 h-12 bg-blue-500/20 rounded-xl flex items-center justify-center mb-6">
                <Brain className="h-6 w-6 text-blue-400" />
              </div>
              <h3 className="text-xl font-semibold mb-4 text-white">Natural Language → Strategy</h3>
              <p className="text-slate-300 leading-relaxed">
                Describe your betting idea (filters, odds, rest, injuries, trends). We convert it into an executable strategy.
              </p>
            </div>

            <div className="bg-gradient-to-br from-slate-900/50 to-slate-800/30 border border-white/10 rounded-2xl p-8">
              <div className="w-12 h-12 bg-green-500/20 rounded-xl flex items-center justify-center mb-6">
                <BarChart3 className="h-6 w-6 text-green-400" />
              </div>
              <h3 className="text-xl font-semibold mb-4 text-white">Real Backtesting</h3>
              <p className="text-slate-300 leading-relaxed">
                Run on real sports data with a specified time period (e.g. “2023–24 season”). No fabricated metrics.
              </p>
            </div>

            <div className="bg-gradient-to-br from-slate-900/50 to-slate-800/30 border border-white/10 rounded-2xl p-8">
              <div className="w-12 h-12 bg-purple-500/20 rounded-xl flex items-center justify-center mb-6">
                <Download className="h-6 w-6 text-purple-400" />
              </div>
              <h3 className="text-xl font-semibold mb-4 text-white">Charts + Downloads</h3>
              <p className="text-slate-300 leading-relaxed">
                View a trade-level profit chart and download CSV/text reports you can share or archive.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Next steps */}
      <section className="py-24 bg-slate-900/50">
        <div className="mx-auto max-w-7xl px-6">
          <div className="mx-auto max-w-4xl rounded-2xl border border-white/10 bg-slate-900/50 p-8">
            <h2 className="text-3xl font-bold text-white mb-4">Try a real run</h2>
            <ol className="mt-4 space-y-3 text-slate-300">
              <li className="flex gap-3">
                <span className="mt-1 h-2 w-2 rounded-full bg-blue-400" />
                Sign up and open the dashboard chat.
              </li>
              <li className="flex gap-3">
                <span className="mt-1 h-2 w-2 rounded-full bg-blue-400" />
                Ask for a strategy and include a time period (e.g. “2023–24 season”).
              </li>
              <li className="flex gap-3">
                <span className="mt-1 h-2 w-2 rounded-full bg-blue-400" />
                Review the chart, then download CSV/text reports.
              </li>
            </ol>

            <div className="mt-8 flex flex-col sm:flex-row gap-3">
              <Link
                href="/signup?trial=true"
                className="inline-flex items-center justify-center gap-2 rounded-xl bg-blue-600 px-6 py-3 font-semibold text-white hover:bg-blue-500"
              >
                <Play className="h-5 w-5" />
                Start Trial
              </Link>
              <Link
                href="/login"
                className="inline-flex items-center justify-center gap-2 rounded-xl border border-white/10 bg-slate-950/40 px-6 py-3 font-semibold text-white hover:bg-white/5"
              >
                <MessageSquare className="h-5 w-5" />
                Log in
              </Link>
              <Link
                href="/backtest"
                className="inline-flex items-center justify-center gap-2 rounded-xl border border-white/10 bg-slate-950/40 px-6 py-3 font-semibold text-white hover:bg-white/5"
              >
                <Download className="h-5 w-5" />
                Backtest History
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-24 bg-gradient-to-r from-blue-600 to-purple-600">
        <div className="mx-auto max-w-7xl px-6 text-center">
          <h2 className="text-4xl md:text-5xl font-bold mb-6">Ready to upgrade your betting workflow?</h2>
          <p className="text-xl mb-8 text-blue-100">Create strategies, backtest them, and export results in minutes.</p>
          <Link
            href="/signup?trial=true"
            className="inline-flex items-center gap-3 bg-white text-blue-600 hover:bg-blue-50 px-8 py-4 rounded-xl font-semibold text-lg transition-all transform hover:scale-105 shadow-xl"
          >
            Start Trial - $1 for 7 Days
          </Link>
        </div>
      </section>
    </div>
  );
}
