import Link from "next/link";
import { ArrowLeft } from "lucide-react";

export default function CookiesPage() {
  return (
    <main className="min-h-screen bg-slate-950 text-white">
      <div className="max-w-4xl mx-auto px-6 py-12">
        <Link href="/" className="inline-flex items-center gap-2 text-slate-400 hover:text-white transition-colors mb-8">
          <ArrowLeft className="h-4 w-4" />
          Back to Home
        </Link>

        <div className="space-y-8">
          <div>
            <h1 className="text-4xl font-bold mb-4">Cookie Policy</h1>
            <p className="text-slate-400">Last updated: November 23, 2025</p>
          </div>

          <div className="glass-panel p-8 rounded-xl space-y-6">
            <section>
              <h2 className="text-2xl font-semibold mb-4">What Are Cookies</h2>
              <p className="text-slate-300">
                Cookies are small text files that are stored on your computer or mobile device when you visit our website.
                They allow us to remember your preferences and improve your browsing experience.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">How We Use Cookies</h2>
              <p className="text-slate-300 mb-4">We use cookies for the following purposes:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li><strong>Essential Cookies:</strong> Required for the website to function properly</li>
                <li><strong>Analytics Cookies:</strong> Help us understand how visitors use our website</li>
                <li><strong>Preference Cookies:</strong> Remember your settings and preferences</li>
                <li><strong>Authentication Cookies:</strong> Keep you logged in during your session</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Types of Cookies We Use</h2>
              <div className="space-y-4">
                <div className="border border-white/10 rounded-lg p-4">
                  <h3 className="text-lg font-semibold text-white mb-2">Session Cookies</h3>
                  <p className="text-slate-300">Temporary cookies that expire when you close your browser</p>
                </div>
                <div className="border border-white/10 rounded-lg p-4">
                  <h3 className="text-lg font-semibold text-white mb-2">Persistent Cookies</h3>
                  <p className="text-slate-300">Cookies that remain on your device for a set period or until deleted</p>
                </div>
                <div className="border border-white/10 rounded-lg p-4">
                  <h3 className="text-lg font-semibold text-white mb-2">Third-party Cookies</h3>
                  <p className="text-slate-300">Cookies set by third-party services we use (analytics, payment processing)</p>
                </div>
              </div>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Managing Cookies</h2>
              <p className="text-slate-300 mb-4">You can control and manage cookies in various ways:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Most web browsers allow you to control cookies through their settings</li>
                <li>You can delete all cookies that are already on your computer</li>
                <li>You can set most browsers to prevent cookies from being placed</li>
                <li>Note that disabling cookies may affect the functionality of our website</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Third-party Services</h2>
              <p className="text-slate-300 mb-4">We may use third-party services that set their own cookies:</p>
              <ul className="list-disc list-inside text-slate-300 space-y-2">
                <li>Analytics services to understand website usage</li>
                <li>Payment processors for subscription billing</li>
                <li>Customer support chat services</li>
              </ul>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Updates to This Policy</h2>
              <p className="text-slate-300">
                We may update this Cookie Policy from time to time. We will notify you of any changes by posting
                the new policy on this page and updating the "Last updated" date.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-semibold mb-4">Contact Us</h2>
              <p className="text-slate-300">
                If you have any questions about our use of cookies, please contact us at{" "}
                <a href="mailto:privacy@eventheodds.ai" className="text-blue-400 hover:text-blue-300">
                  privacy@eventheodds.ai
                </a>
              </p>
            </section>
          </div>
        </div>
      </div>
    </main>
  );
}
