import Link from "next/link";
import { ArrowLeft, Mail, MessageSquare, Phone } from "lucide-react";

export default function ContactPage() {
  return (
    <main className="min-h-screen bg-slate-950 text-white">
      <div className="max-w-4xl mx-auto px-6 py-12">
        <Link href="/" className="inline-flex items-center gap-2 text-slate-400 hover:text-white transition-colors mb-8">
          <ArrowLeft className="h-4 w-4" />
          Back to Home
        </Link>

        <div className="space-y-8">
          <div className="text-center">
            <h1 className="text-4xl font-bold mb-4">Contact Us</h1>
            <p className="text-slate-400 max-w-2xl mx-auto">
              Have questions about EventheOdds.ai? We're here to help. Get in touch with our team.
            </p>
          </div>

          <div className="grid md:grid-cols-2 gap-8">
            {/* Contact Methods */}
            <div className="space-y-6">
              <h2 className="text-2xl font-semibold mb-6">Get in Touch</h2>

              <div className="space-y-4">
                <div className="flex items-center gap-4 p-4 glass-panel rounded-xl hover:bg-white/5 transition-colors">
                  <div className="w-12 h-12 bg-blue-500/20 rounded-xl flex items-center justify-center">
                    <Mail className="h-6 w-6 text-blue-400" />
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold text-white">Email Support</h3>
                    <p className="text-slate-400">support@eventheodds.ai</p>
                    <p className="text-sm text-slate-500">24-48 hour response time</p>
                  </div>
                </div>

                <div className="flex items-center gap-4 p-4 glass-panel rounded-xl hover:bg-white/5 transition-colors">
                  <div className="w-12 h-12 bg-green-500/20 rounded-xl flex items-center justify-center">
                    <MessageSquare className="h-6 w-6 text-green-400" />
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold text-white">Live Chat</h3>
                    <p className="text-slate-400">Available in dashboard</p>
                    <p className="text-sm text-slate-500">Instant responses during business hours</p>
                  </div>
                </div>

                <div className="flex items-center gap-4 p-4 glass-panel rounded-xl hover:bg-white/5 transition-colors">
                  <div className="w-12 h-12 bg-purple-500/20 rounded-xl flex items-center justify-center">
                    <Phone className="h-6 w-6 text-purple-400" />
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold text-white">Business Inquiries</h3>
                    <p className="text-slate-400">business@eventheodds.ai</p>
                    <p className="text-sm text-slate-500">For partnerships and enterprise solutions</p>
                  </div>
                </div>
              </div>

              <div className="glass-panel p-6 rounded-xl">
                <h3 className="text-lg font-semibold text-white mb-3">Business Hours</h3>
                <div className="text-slate-300 space-y-1">
                  <p>Monday - Friday: 9:00 AM - 6:00 PM EST</p>
                  <p>Saturday: 10:00 AM - 4:00 PM EST</p>
                  <p>Sunday: Closed</p>
                </div>
              </div>
            </div>

            {/* FAQ Section */}
            <div className="space-y-6">
              <h2 className="text-2xl font-semibold mb-6">Frequently Asked Questions</h2>

              <div className="space-y-4">
                <div className="glass-panel p-6 rounded-xl">
                  <h3 className="text-lg font-semibold text-white mb-2">How do I get started?</h3>
                  <p className="text-slate-400 text-sm">
                    Sign up for a free trial account and start backtesting strategies immediately.
                    No credit card required for the trial period.
                  </p>
                </div>

                <div className="glass-panel p-6 rounded-xl">
                  <h3 className="text-lg font-semibold text-white mb-2">What markets do you support?</h3>
                  <p className="text-slate-400 text-sm">
                    We support sports betting backtesting across major leagues (NBA, NFL, MLB, NHL, and more as data is available).
                  </p>
                </div>

                <div className="glass-panel p-6 rounded-xl">
                  <h3 className="text-lg font-semibold text-white mb-2">Is my data secure?</h3>
                  <p className="text-slate-400 text-sm">
                    Yes, we use bank-level encryption and security measures to protect your data and strategies.
                  </p>
                </div>

                <div className="glass-panel p-6 rounded-xl">
                  <h3 className="text-lg font-semibold text-white mb-2">Do you provide financial advice?</h3>
                  <p className="text-slate-400 text-sm">
                    No. We provide educational tools only. Always bet responsibly and comply with local laws and regulations.
                  </p>
                </div>
              </div>

              <div className="text-center">
                <Link href="/help" className="text-blue-400 hover:text-blue-300 transition-colors">
                  View Full Help Center →
                </Link>
              </div>
            </div>
          </div>

          {/* Additional Resources */}
          <div className="glass-panel p-8 rounded-xl text-center">
            <h2 className="text-2xl font-semibold mb-4">Need More Help?</h2>
            <p className="text-slate-400 mb-6 max-w-2xl mx-auto">
              Check out our comprehensive help center for tutorials, guides, and community discussions.
            </p>
            <div className="flex flex-wrap gap-4 justify-center">
              <Link href="/help" className="px-6 py-3 bg-blue-600 hover:bg-blue-500 text-white rounded-xl font-semibold transition-all hover:scale-105">
                Help Center
              </Link>
              <Link href="/community" className="px-6 py-3 glass-panel hover:bg-white/5 text-white rounded-xl font-semibold transition-all hover:scale-105">
                Community Forum
              </Link>
              <Link href="/demo" className="px-6 py-3 glass-panel hover:bg-white/5 text-white rounded-xl font-semibold transition-all hover:scale-105">
                Interactive Demo
              </Link>
            </div>
          </div>
        </div>
      </div>
    </main>
  );
}
