import Link from 'next/link';
import { ArrowLeft, Users } from 'lucide-react';

import { StrategyLibrary } from '@/components/StrategyLibrary';

export default function CommunityPage() {
  return (
    <div className="min-h-screen bg-slate-950">
      <header className="bg-slate-900/50 border-b border-white/10">
        <div className="mx-auto max-w-7xl px-6 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center gap-4">
              <Link href="/dashboard" className="text-slate-400 hover:text-white transition">
                <ArrowLeft className="h-5 w-5" />
              </Link>
              <div>
                <h1 className="text-2xl font-bold text-white">Community Library</h1>
                <p className="text-slate-400 text-sm">Browse and share sports betting strategies</p>
              </div>
            </div>

            <div className="flex items-center gap-2 bg-slate-800/50 rounded-lg px-3 py-2">
              <Users className="h-4 w-4 text-slate-400" />
              <span className="text-slate-300 text-sm">Public strategies</span>
            </div>
          </div>
        </div>
      </header>

      <div className="mx-auto max-w-7xl px-6 py-8">
        <StrategyLibrary />
      </div>
    </div>
  );
}

