import { NextRequest, NextResponse } from 'next/server';
import { AuthMiddleware, DatabaseService } from '@/lib/auth';
import { z } from 'zod';

const schema = z.object({
  announcementId: z.string().min(1),
});

export async function POST(request: NextRequest) {
  try {
    const authResponse = await AuthMiddleware.requireAuth(request);
    if (authResponse) return authResponse;

    const user = (request as any).user;
    const body = await request.json();
    const { announcementId } = schema.parse(body);

    await DatabaseService.recordUserEvent(user.id, 'ANNOUNCEMENT_READ', { announcementId });

    return NextResponse.json({ success: true });
  } catch (error) {
    console.error('[api/announcements/read] failed', error);
    return NextResponse.json({ error: 'Failed to mark announcement read' }, { status: 500 });
  }
}


