import { FileText } from 'lucide-react';

import { DataService } from '@/services/DataService';

export const dynamic = 'force-dynamic';

export default async function DataManagerPage() {
  const dataService = DataService.getInstance();
  const datasets = await dataService.getAllDatasetsMeta();

  return (
    <div className="space-y-8">
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-2xl font-bold text-white">Data Manager</h1>
          <p className="text-slate-400">
            View active datasets used for backtesting.
          </p>
        </div>
      </div>

      <div className="rounded-2xl border border-white/10 bg-slate-900/50">
        <div className="border-b border-white/10 px-6 py-4">
          <h3 className="font-semibold text-white">Active Datasets</h3>
        </div>
        <div className="divide-y divide-white/5">
          {datasets.map((ds) => (
            <div
              key={ds.id}
              className="flex items-center justify-between px-6 py-4 hover:bg-white/5"
            >
              <div className="flex items-center gap-4">
                <div className="flex h-10 w-10 items-center justify-center rounded-lg bg-slate-800 text-slate-400">
                  <FileText className="h-5 w-5" />
                </div>
                <div>
                  <p className="font-medium text-slate-200">{ds.id}</p>
                  <div className="flex gap-4 text-xs text-slate-500">
                    <span className="uppercase">{ds.domain}</span>
                    <span>•</span>
                    <span>{ds.rowCount} records</span>
                    <span>•</span>
                    <span>{(ds.sizeBytes / 1024).toFixed(1)} KB</span>
                    <span>•</span>
                    <span suppressHydrationWarning>
                      Updated {new Date(ds.lastModified).toLocaleString()}
                    </span>
                  </div>
                </div>
              </div>
              <span className="rounded-full bg-emerald-500/10 px-2.5 py-0.5 text-xs font-medium text-emerald-500">
                Active
              </span>
            </div>
          ))}
        </div>
      </div>

      <div className="rounded-2xl border border-white/10 bg-slate-900/50 p-6">
        <h3 className="font-semibold text-white">Where this data lives</h3>
        <p className="mt-2 text-sm text-slate-400">
          CSV datasets are stored under <span className="text-slate-200">data/csv/</span> on the server.
          SportsData.io caches are stored under <span className="text-slate-200">data/*_cache/</span>.
        </p>
      </div>
    </div>
  );
}

