#!/bin/bash

# Start Advanced RAG Service for Sports Betting
# Features: FAISS + BM25 hybrid search, structure-aware chunking, DeepSeek OCR fallback
echo "Starting Advanced Sports Betting RAG Service..."
echo "================================================================"

# Set the working directory
cd "$(dirname "$0")/.."

# Use the leadgen RAG venv which has all dependencies (FAISS, SentenceTransformers, etc.)
VENV_DIR="/var/www/html/leadgen/airagagent/rag_env"
if [ -d "$VENV_DIR" ]; then
    echo "🔄 Activating leadgen RAG virtual environment..."
    source "$VENV_DIR/bin/activate"
else
    # Fallback to local venv
    VENV_DIR="python_service/venv"
    if [ -d "$VENV_DIR" ]; then
        echo "🔄 Activating local virtual environment..."
        source "$VENV_DIR/bin/activate"
    else
        echo "❌ No virtual environment found"
        exit 1
    fi
fi

# Load environment variables (use grep to avoid shell interpretation issues)
if [ -f ".env" ]; then
    echo "🔄 Loading environment variables from .env..."
    export FLASK_API_KEY=$(grep "^FLASK_API_KEY=" .env | cut -d'=' -f2)
    export OPENAI_API_KEY=$(grep "^OPENAI_API_KEY=" .env | cut -d'=' -f2)
    export GROK_API_KEY=$(grep "^GROK_API_KEY=" .env | cut -d'=' -f2)
fi

# Set data directory
export DATA_DIR="${DATA_DIR:-/var/www/html/eventheodds/data}"
export RAG_PORT="${RAG_PORT:-5001}"

echo "📁 Data directory: $DATA_DIR"
echo "🌐 RAG Port: $RAG_PORT"

# Start the Advanced RAG service
echo "🚀 Starting Advanced RAG Service (FAISS + BM25 Hybrid Search)..."
exec python python_service/advanced_rag_service.py
