#!/bin/bash
# Install Sports Data Updater as a systemd service
# Run with: sudo bash install_updater_service.sh

set -e

echo "=== Installing Sports Data Updater Service ==="

# Copy service files
sudo cp /var/www/html/eventheodds/config/sports-data-updater.service /etc/systemd/system/
sudo cp /var/www/html/eventheodds/config/sports-data-updater.timer /etc/systemd/system/

# Create log file with proper permissions
sudo touch /var/log/sports_data_updater.log
sudo chown administrator:administrator /var/log/sports_data_updater.log

# Reload systemd
sudo systemctl daemon-reload

# Enable and start the timer
sudo systemctl enable sports-data-updater.timer
sudo systemctl start sports-data-updater.timer

# Show status
echo ""
echo "=== Service Status ==="
sudo systemctl status sports-data-updater.timer --no-pager || true

echo ""
echo "=== Timer Schedule ==="
sudo systemctl list-timers sports-data-updater.timer --no-pager || true

echo ""
echo "=== Installation Complete ==="
echo "The updater will run:"
echo "  - Daily at 4:00 AM"
echo "  - 15 minutes after each reboot"
echo ""
echo "Manual commands:"
echo "  Start now:     sudo systemctl start sports-data-updater.service"
echo "  View logs:     tail -f /var/log/sports_data_updater.log"
echo "  Check status:  sudo systemctl status sports-data-updater.timer"
echo "  Disable:       sudo systemctl disable sports-data-updater.timer"
